/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class Browser
extends JEditorPane
implements HyperlinkListener {
    private static final long serialVersionUID = -2342332990027338104L;

    public Browser() {
        this.setEditable(false);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)this.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    this.setPage(e.getURL());
                }
                catch (Throwable t) {
                    SwingTools.showErrorMessage("While following link:", t);
                }
            }
        }
    }

    private JMenuItem createItem(String name, final URL url) {
        if (url != null) {
            JMenuItem item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        Browser.this.setPage(url);
                    }
                    catch (IOException t) {
                        SwingTools.showErrorMessage("Cannot find '" + url + "'", t);
                    }
                }
            });
            return item;
        }
        return null;
    }

    public static void showDialog(URL url) {
        Browser browser = new Browser();
        JDialog dialog = new JDialog();
        dialog.setTitle("Yale Browser");
        JMenuBar menuBar = new JMenuBar();
        JMenu visitMenu = new JMenu("Browse");
        JMenuItem item = browser.createItem("Yale GUI Manual", Tools.getResource("manual/YaleGUIManual.html"));
        if (item != null) {
            visitMenu.add(item);
        } else {
            LogService.logMessage("Cannot show GUI manual: resource 'manual/YaleGUIManual.html' not found...", 4);
        }
        try {
            item = browser.createItem("Yale@WWW", new URL("http://yale.sf.net"));
            if (item != null) {
                visitMenu.add(item);
            } else {
                LogService.logMessage("Cannot show YALE web site: URL 'http://yale.sf.net' not found...", 4);
            }
        }
        catch (MalformedURLException e) {
            LogService.logMessage("Cannot show YALE web site: " + e.getMessage(), 4);
        }
        item = browser.createItem("License", Tools.getResource("LICENSE.html"));
        if (item != null) {
            visitMenu.add(item);
        } else {
            LogService.logMessage("Cannot show license: resource 'LICENSE.html' not found...", 4);
        }
        menuBar.add(visitMenu);
        dialog.setJMenuBar(menuBar);
        JScrollPane editorScrollPane = new JScrollPane(browser);
        editorScrollPane.setPreferredSize(new Dimension(600, 500));
        dialog.getContentPane().add(editorScrollPane);
        dialog.pack();
        dialog.setVisible(true);
        try {
            browser.setPage(url);
        }
        catch (Throwable e) {
            SwingTools.showErrorMessage("Cannot find '" + url + "'!", e);
        }
    }
}

