/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.dialog;

import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.math.AnovaCalculator;
import edu.udo.cs.yale.tools.math.SignificanceCalculationException;
import edu.udo.cs.yale.tools.math.SignificanceTestResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class AnovaCalculatorDialog
extends JDialog {
    private static final long serialVersionUID = 3023267244921354296L;
    private transient AnovaCalculator calculator = new AnovaCalculator();
    private AnovaTableModel tableModel;

    public AnovaCalculatorDialog(Frame owner) {
        super(owner, "Anova Calculator", false);
        this.getContentPane().setLayout(new BorderLayout());
        this.tableModel = new AnovaTableModel();
        ExtendedJTable dataTable = new ExtendedJTable((TableModel)this.tableModel, false);
        this.getContentPane().add((Component)new JScrollPane(dataTable), "Center");
        JPanel inputPanel = new JPanel(new FlowLayout());
        JLabel label = new JLabel("Mean:");
        inputPanel.add(label);
        final JTextField meanField = new JTextField(8);
        inputPanel.add(meanField);
        label = new JLabel("Variance:");
        inputPanel.add(label);
        final JTextField varianceField = new JTextField(8);
        inputPanel.add(varianceField);
        label = new JLabel("Number:");
        inputPanel.add(label);
        final JTextField numberField = new JTextField(8);
        inputPanel.add(numberField);
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double mean = Double.NaN;
                String meanString = meanField.getText();
                if (meanString != null && meanString.trim().length() > 0) {
                    try {
                        mean = Double.parseDouble(meanString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'mean' must contain a real-valued number.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'mean' must contain a real-valued number.");
                    return;
                }
                double variance = Double.NaN;
                String varianceString = varianceField.getText();
                if (varianceString != null && varianceString.trim().length() > 0) {
                    try {
                        variance = Double.parseDouble(varianceString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'variance' must contain a real-valued number.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'variance' must contain a real-valued number.");
                    return;
                }
                int number = -1;
                String numberString = numberField.getText();
                if (numberString != null && numberString.trim().length() > 0) {
                    try {
                        number = Integer.parseInt(numberString);
                    }
                    catch (NumberFormatException ex) {
                        SwingTools.showVerySimpleErrorMessage("The field 'number' must contain a positive integer number > 1.");
                        return;
                    }
                } else {
                    SwingTools.showVerySimpleErrorMessage("The field 'number' must contain a positive integer number > 1.");
                    return;
                }
                if (!Double.isNaN(mean) && !Double.isNaN(variance) && number > 1) {
                    AnovaCalculatorDialog.this.tableModel.addRow(new Object[]{new Double(mean), new Double(variance), number});
                }
            }
        });
        inputPanel.add(addButton);
        this.getContentPane().add((Component)inputPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton calculateButton = new JButton("Calculate...");
        calculateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    AnovaCalculatorDialog.this.calculateANOVA();
                }
                catch (SignificanceCalculationException e1) {
                    SwingTools.showSimpleErrorMessage("Cannot calculate ANOVA: ", e1);
                }
            }
        });
        buttonPanel.add(calculateButton);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnovaCalculatorDialog.this.clearData();
            }
        });
        buttonPanel.add(clearButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnovaCalculatorDialog.this.close();
            }
        });
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(600, 400);
        this.setLocationRelativeTo(owner);
    }

    public Object readResolve() {
        this.calculator = new AnovaCalculator();
        return this;
    }

    private void close() {
        this.dispose();
    }

    private void clearData() {
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
    }

    private void calculateANOVA() throws SignificanceCalculationException {
        this.calculator.clearGroups();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            int number = (Integer)this.tableModel.getValueAt(i, 2);
            double mean = (Double)this.tableModel.getValueAt(i, 0);
            double variance = (Double)this.tableModel.getValueAt(i, 1);
            this.calculator.addGroup(number, mean, variance);
            ++i;
        }
        if (this.tableModel.getRowCount() < 2) {
            SwingTools.showVerySimpleErrorMessage("You need to add at least two rows in order to calculate an ANOVA test.");
            return;
        }
        SignificanceTestResult result = this.calculator.performSignificanceTest();
        JOptionPane.showMessageDialog(this, result.getVisualizationComponent(null), "ANOVA result", -1);
    }

    private static class AnovaTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -2904775003271582149L;

        public AnovaTableModel() {
            super(new String[]{"mean", "variance", "number"}, 0);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

