/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.attributeeditor.actions;

import edu.udo.cs.yale.gui.attributeeditor.AttributeEditor;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class SaveDataAction
extends AbstractAction {
    private static final long serialVersionUID = -4272773008253836867L;
    private static final String ICON_NAME = "data_disk.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private AttributeEditor attributeEditor;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            IconSize size = iconSizeArray[n];
            SaveDataAction.ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + ICON_NAME);
            ++n;
        }
    }

    public SaveDataAction(AttributeEditor attributeEditor, IconSize size) {
        super("Save Data as...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Save the contents of the table to a single data file");
        this.putValue("MnemonicKey", 86);
        this.attributeEditor = attributeEditor;
    }

    public void actionPerformed(ActionEvent e) {
        File file = SwingTools.chooseFile((Component)this.attributeEditor, null, false, "dat", "data file");
        if (file != null) {
            try {
                this.attributeEditor.writeData(file);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.attributeEditor, e.toString(), "Error saving data file " + file, 0);
            }
        }
    }
}

