/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.attributeeditor;

import edu.udo.cs.yale.gui.attributeeditor.AttributeEditor;
import edu.udo.cs.yale.gui.attributeeditor.DataControl;
import edu.udo.cs.yale.gui.attributeeditor.actions.ClearAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.CloseAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.LoadDataAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.LoadSeriesDataAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.OpenAttributeFileAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.SaveAttributeFileAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.SaveDataAction;
import edu.udo.cs.yale.gui.tools.ExtendedToolBar;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class AttributeEditorDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = 6448298163392765295L;
    private AttributeEditor attributeEditor;
    public Action OPEN_ATTRIBUTE_FILE_ACTION_24;
    public Action OPEN_ATTRIBUTE_FILE_ACTION_32;
    public Action SAVE_ATTRIBUTE_FILE_ACTION_24;
    public Action SAVE_ATTRIBUTE_FILE_ACTION_32;
    public Action LOAD_DATA_ACTION_24;
    public Action LOAD_DATA_ACTION_32;
    public Action LOAD_SERIES_DATA_ACTION_24;
    public Action LOAD_SERIES_DATA_ACTION_32;
    public Action SAVE_DATA_ACTION_24;
    public Action SAVE_DATA_ACTION_32;
    public Action CLEAR_ACTION_24;
    public Action CLEAR_ACTION_32;
    public Action CLOSE_ACTION_24;
    public Action CLOSE_ACTION_32;

    public AttributeEditorDialog(JFrame owner, Operator exampleSource, File file) {
        this(owner, exampleSource);
        if (file != null) {
            this.attributeEditor.openAttributeFile(file);
        }
    }

    public AttributeEditorDialog(JFrame owner, Operator exampleSource) {
        super(owner, "Attribute Editor", true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        DataControl control = new DataControl(0, 0, "Example", "Attribute", false);
        this.attributeEditor = new AttributeEditor(exampleSource, control);
        control.addViewChangeListener(this.attributeEditor);
        this.getContentPane().add((Component)control, "West");
        this.getContentPane().add((Component)new JScrollPane(this.attributeEditor), "Center");
        control.update();
        this.initActions();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.OPEN_ATTRIBUTE_FILE_ACTION_24);
        fileMenu.add(this.SAVE_ATTRIBUTE_FILE_ACTION_24);
        fileMenu.add(this.LOAD_DATA_ACTION_24);
        fileMenu.add(this.SAVE_DATA_ACTION_24);
        fileMenu.add(this.LOAD_SERIES_DATA_ACTION_24);
        fileMenu.addSeparator();
        fileMenu.add(this.CLOSE_ACTION_24);
        menuBar.add(fileMenu);
        JMenu tableMenu = new JMenu("Table");
        tableMenu.add(this.attributeEditor.GUESS_TYPE_ACTION_24);
        tableMenu.add(this.attributeEditor.GUESS_ALL_TYPES_ACTION_24);
        tableMenu.add(this.attributeEditor.REMOVE_COLUMN_ACTION_24);
        tableMenu.add(this.attributeEditor.REMOVE_ROW_ACTION_24);
        tableMenu.add(this.attributeEditor.USE_ROW_AS_NAMES_ACTION_24);
        tableMenu.add(this.CLEAR_ACTION_24);
        menuBar.add(tableMenu);
        this.setJMenuBar(menuBar);
        ExtendedToolBar toolBar = new ExtendedToolBar();
        toolBar.add(this.OPEN_ATTRIBUTE_FILE_ACTION_32);
        toolBar.add(this.SAVE_ATTRIBUTE_FILE_ACTION_32);
        toolBar.add(this.LOAD_DATA_ACTION_32);
        toolBar.add(this.SAVE_DATA_ACTION_32);
        toolBar.addSeparator();
        toolBar.add(this.CLEAR_ACTION_32);
        this.getContentPane().add((Component)toolBar, "North");
        this.setSize((int)Math.max(600.0, (double)owner.getWidth() * 2.0 / 3.0), (int)Math.max(400.0, (double)owner.getHeight() * 2.0 / 3.0));
        this.setLocationRelativeTo(owner);
    }

    public void initActions() {
        this.OPEN_ATTRIBUTE_FILE_ACTION_24 = new OpenAttributeFileAction(this.attributeEditor, IconSize.SMALL);
        this.OPEN_ATTRIBUTE_FILE_ACTION_32 = new OpenAttributeFileAction(this.attributeEditor, IconSize.MIDDLE);
        this.SAVE_ATTRIBUTE_FILE_ACTION_24 = new SaveAttributeFileAction(this.attributeEditor, IconSize.SMALL);
        this.SAVE_ATTRIBUTE_FILE_ACTION_32 = new SaveAttributeFileAction(this.attributeEditor, IconSize.MIDDLE);
        this.LOAD_DATA_ACTION_24 = new LoadDataAction(this.attributeEditor, IconSize.SMALL);
        this.LOAD_DATA_ACTION_32 = new LoadDataAction(this.attributeEditor, IconSize.MIDDLE);
        this.LOAD_SERIES_DATA_ACTION_24 = new LoadSeriesDataAction(this.attributeEditor, IconSize.SMALL);
        this.LOAD_SERIES_DATA_ACTION_32 = new LoadSeriesDataAction(this.attributeEditor, IconSize.MIDDLE);
        this.SAVE_DATA_ACTION_24 = new SaveDataAction(this.attributeEditor, IconSize.SMALL);
        this.SAVE_DATA_ACTION_32 = new SaveDataAction(this.attributeEditor, IconSize.MIDDLE);
        this.CLEAR_ACTION_24 = new ClearAction(this.attributeEditor, IconSize.SMALL);
        this.CLEAR_ACTION_32 = new ClearAction(this.attributeEditor, IconSize.MIDDLE);
        this.CLOSE_ACTION_24 = new CloseAction(this, IconSize.SMALL);
        this.CLOSE_ACTION_32 = new CloseAction(this, IconSize.MIDDLE);
    }

    public File getFile() {
        return this.attributeEditor.getFile();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void close() {
        if (this.attributeEditor.hasDataChanged()) {
            int selectedOption = JOptionPane.showConfirmDialog(this, "It seems that you have changed the data without saving it afterwards." + Tools.getLineSeparator() + "Do you still want to proceed and close the editor (changes will be lost)?", "Save data file?", 0, 3);
            if (selectedOption == 0) {
                this.dispose();
            }
        } else if (this.attributeEditor.hasMetaDataChanged()) {
            int selectedOption = JOptionPane.showConfirmDialog(this, "It seems that you have changed the attribute descriptions without saving an attribute description file (.aml) afterwards." + Tools.getLineSeparator() + "Do you still want to proceed and close the editor (changes will be lost)?", "Save attribute description file?", 0, 3);
            if (selectedOption == 0) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }
}

