/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.attributeeditor;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.FileDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.YaleLineReader;
import edu.udo.cs.yale.gui.EditorCellRenderer;
import edu.udo.cs.yale.gui.attributeeditor.CellEditors;
import edu.udo.cs.yale.gui.attributeeditor.CellRenderers;
import edu.udo.cs.yale.gui.attributeeditor.DataControl;
import edu.udo.cs.yale.gui.attributeeditor.DataControlListener;
import edu.udo.cs.yale.gui.attributeeditor.actions.GuessAllTypesAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.GuessTypeAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.RemoveColumnAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.RemoveRowAction;
import edu.udo.cs.yale.gui.attributeeditor.actions.UseRowAsNamesAction;
import edu.udo.cs.yale.gui.tools.ExtendedJTable;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeDataSource;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AttributeEditor
extends ExtendedJTable
implements MouseListener,
DataControlListener {
    private static final long serialVersionUID = -3312532913749370288L;
    public static final int LOAD_DATA = 0;
    public static final int LOAD_SERIES_DATA = 1;
    private static final int COLUMN_WIDTH = 120;
    protected Action REMOVE_COLUMN_ACTION_24 = new RemoveColumnAction(this, IconSize.SMALL);
    protected Action REMOVE_COLUMN_ACTION_32 = new RemoveColumnAction(this, IconSize.MIDDLE);
    protected Action REMOVE_ROW_ACTION_24 = new RemoveRowAction(this, IconSize.SMALL);
    protected Action REMOVE_ROW_ACTION_32 = new RemoveRowAction(this, IconSize.MIDDLE);
    protected Action USE_ROW_AS_NAMES_ACTION_24 = new UseRowAsNamesAction(this, IconSize.SMALL);
    protected Action USE_ROW_AS_NAMES_ACTION_32 = new UseRowAsNamesAction(this, IconSize.MIDDLE);
    protected Action GUESS_TYPE_ACTION_24 = new GuessTypeAction(this, IconSize.SMALL);
    protected Action GUESS_TYPE_ACTION_32 = new GuessTypeAction(this, IconSize.MIDDLE);
    protected Action GUESS_ALL_TYPES_ACTION_24 = new GuessAllTypesAction(this, IconSize.SMALL);
    protected Action GUESS_ALL_TYPES_ACTION_32 = new GuessAllTypesAction(this, IconSize.MIDDLE);
    private static final int NAME_ROW = 0;
    private static final int TYPE_ROW = 1;
    private static final int VALUE_TYPE_ROW = 2;
    private static final int BLOCK_TYPE_ROW = 3;
    private static final int SEPARATOR_ROW = 4;
    private static final int NUM_OF_HEADER_ROWS = 5;
    private transient CellEditors cellEditors = new CellEditors(5);
    private transient CellRenderers cellRenderers = new CellRenderers(5);
    private transient TableCellRenderer dataRenderer = new DataCellRenderer();
    private ArrayList<AttributeDataSource> sourceList = new ArrayList();
    private File file;
    private transient Operator exampleSource;
    private AttributeTableModel model;
    private int rowCount = 0;
    private int firstRow = 1;
    private int lastRow = 10;
    private int firstColumn = 1;
    private int lastColumn = 10;
    private boolean dataChanged = false;
    private boolean metaDataChanged = false;
    private Vector<Vector<String>> dataColumnVector = new Vector();
    private DataControl dataControl;

    public AttributeEditor(Operator exampleSource, DataControl dataControl) {
        super(null, false);
        this.dataControl = dataControl;
        this.model = new AttributeTableModel();
        this.setModel(this.model);
        this.exampleSource = exampleSource;
        this.setRowHeight(this.getRowHeight() + 10);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.addMouseListener(this);
    }

    public Object readResolve() {
        this.cellEditors = new CellEditors(5);
        this.cellRenderers = new CellRenderers(5);
        this.dataRenderer = new DataCellRenderer();
        return this;
    }

    public boolean hasDataChanged() {
        return this.dataChanged;
    }

    public boolean hasMetaDataChanged() {
        return this.metaDataChanged;
    }

    private AttributeDataSource getDataSource(int i) {
        return this.sourceList.get(i);
    }

    private String getDatum(int row, int column) {
        Vector<String> col = this.dataColumnVector.get(column);
        if (row >= col.size()) {
            return "?";
        }
        return col.get(row);
    }

    private void setDatum(int row, int column, String value) {
        Vector<String> col = this.dataColumnVector.get(column);
        if (row >= col.size()) {
            col.addElement(value);
            if (row >= this.rowCount) {
                this.rowCount = row + 1;
            }
        } else {
            col.setElementAt(value, row);
        }
        this.dataControl.setMaxRows(Math.max(this.dataControl.getMaxRows(), col.size()));
        this.dataControl.setMaxColumns(Math.max(this.dataControl.getMaxColumns(), this.dataColumnVector.size()));
    }

    private int getDefaultMaximumNumber(String limitName, int defaultNumber) {
        String max = System.getProperty("yale.gui.attributeeditor." + limitName);
        if (max != null) {
            try {
                int number = Integer.parseInt(max);
                if (number == -1) {
                    return defaultNumber;
                }
                return number;
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Value of yale.gui.attributeeditor." + limitName + " must be an integer!", 6);
                return defaultNumber;
            }
        }
        return defaultNumber;
    }

    private void createNewColumn() {
        JTextField nameField = new JTextField();
        nameField.setToolTipText("The name of the attribute.");
        this.cellEditors.add(0, new DefaultCellEditor(nameField));
        JComboBox<String> typeBox = new JComboBox<String>(Attributes.KNOWN_ATTRIBUTE_TYPES);
        typeBox.setEditable(true);
        typeBox.setToolTipText("The type of the attribute ('attribute' for regular learning attributes or a special attribute name).");
        this.cellEditors.add(1, new DefaultCellEditor(typeBox));
        String[] allValueTypes = Ontology.ATTRIBUTE_VALUE_TYPE.getNames();
        String[] valueTypes = new String[allValueTypes.length - 1];
        System.arraycopy(allValueTypes, 1, valueTypes, 0, valueTypes.length);
        JComboBox<String> valueTypeBox = new JComboBox<String>(valueTypes);
        valueTypeBox.setToolTipText("The value type of the attribute.");
        this.cellEditors.add(2, new DefaultCellEditor(valueTypeBox));
        JComboBox<String> blockTypeBox = new JComboBox<String>(Ontology.ATTRIBUTE_BLOCK_TYPE.getNames());
        blockTypeBox.setToolTipText("The block type of this attribute.");
        this.cellEditors.add(3, new DefaultCellEditor(blockTypeBox));
        JTextField separator = new JTextField();
        separator.setToolTipText("Separates meta data from data.");
        separator.setEditable(false);
        this.cellEditors.add(4, new DefaultCellEditor(separator));
        int i = 0;
        while (i < this.cellRenderers.getSize()) {
            this.cellRenderers.add(i, new EditorCellRenderer(this.cellEditors.get(i, this.cellEditors.getSize(i) - 1)));
            ++i;
        }
        this.dataColumnVector.add(new Vector());
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        TableColumn column = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1);
        column.setPreferredWidth(120);
    }

    private void addColumn(File file, int index, int valueType) {
        String name = String.valueOf(file.getName()) + " (" + (index + 1) + ")";
        AttributeDataSource source = new AttributeDataSource(AttributeFactory.createAttribute(name, valueType), file, index, "attribute");
        this.createNewColumn();
        this.sourceList.add(source);
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    public void clear() {
        this.sourceList.clear();
        this.dataColumnVector.clear();
        this.rowCount = 0;
        this.dataControl.setMaxRows(0);
        this.dataControl.setMaxColumns(0);
        this.dataControl.update();
        this.dataChanged = false;
        this.metaDataChanged = false;
    }

    public void readData(File file, int dataType) throws IOException {
        String[] columns;
        int columnOffset = this.sourceList.size();
        int numberOfNewColumns = 0;
        int currentRow = -1;
        BufferedReader in = new BufferedReader(new FileReader(file));
        YaleLineReader reader = null;
        try {
            reader = new YaleLineReader(this.exampleSource.getParameterAsString("column_separators"), this.exampleSource.getParameterAsString("comment_chars").toCharArray(), this.exampleSource.getParameterAsBoolean("use_quotes"));
        }
        catch (UndefinedParameterError e) {
            throw new IOException("Cannot create YALE line reader: " + e.getMessage());
        }
        ArrayList<Integer> valueTypes = new ArrayList<Integer>();
        int expectedNumberOfColumns = -1;
        while ((columns = reader.readLine(in, expectedNumberOfColumns)) != null) {
            expectedNumberOfColumns = columns.length;
            ++currentRow;
            int currentColumn = 0;
            while (currentColumn < columns.length) {
                int valueType = 3;
                String value = columns[currentColumn];
                if (!value.equals("?") && value.length() > 0) {
                    try {
                        double d = Double.parseDouble(value);
                        valueType = d == (double)((int)d) ? 3 : 4;
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                    }
                }
                if (currentColumn >= numberOfNewColumns) {
                    this.addColumn(file, currentColumn, valueType);
                    ++numberOfNewColumns;
                    valueTypes.add(valueType);
                } else {
                    int soFar = (Integer)valueTypes.get(currentColumn);
                    if (soFar != valueType) {
                        if (soFar == 1 || valueType == 1) {
                            valueTypes.set(currentColumn, 1);
                        } else {
                            valueTypes.set(currentColumn, 4);
                        }
                    }
                }
                this.setDatum(currentRow, currentColumn + columnOffset, value);
                ++currentColumn;
            }
        }
        in.close();
        int i = 0;
        while (i < valueTypes.size()) {
            this.getDataSource(i + columnOffset).setAttribute(AttributeFactory.changeValueType(this.getDataSource(i + columnOffset).getAttribute(), (Integer)valueTypes.get(i)));
            ++i;
        }
        if (dataType == 1) {
            this.getDataSource(columnOffset).getAttribute().setBlockType(7);
            i = 1;
            while (i < valueTypes.size() - 1) {
                this.getDataSource(i + columnOffset).getAttribute().setBlockType(1);
                ++i;
            }
            this.getDataSource(valueTypes.size() - 1 + columnOffset).getAttribute().setBlockType(8);
        }
        this.update();
        this.dataChanged = false;
        this.metaDataChanged = true;
    }

    public void guessColumnType() {
        int column = this.getSelectedColumn();
        if (column != -1) {
            this.autoSetValueType(column);
        }
    }

    public void guessAllColumnTypes() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.autoSetValueType(i);
            ++i;
        }
    }

    private void autoSetValueType(int column) {
        int valueType = 3;
        AttributeDataSource source = this.getDataSource(column);
        int i = 0;
        while (i < this.rowCount) {
            block4: {
                String value = this.getDatum(i, column);
                if (value != null && !value.equals("?")) {
                    try {
                        double d = Double.parseDouble(value);
                        if (valueType != 3 || (double)((int)d) == d) break block4;
                        valueType = 4;
                    }
                    catch (NumberFormatException e) {
                        valueType = 1;
                        break;
                    }
                }
            }
            ++i;
        }
        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), valueType));
        this.model.fireTableCellUpdated(2, column);
        this.metaDataChanged = true;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        if (row >= 5) {
            return super.getCellEditor(row, column);
        }
        return this.cellEditors.get(row, column);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= 5) {
            return this.dataRenderer;
        }
        return this.cellRenderers.get(row, column);
    }

    private boolean checkData(Object value, int row, int column) {
        return true;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        this.evaluatePopup(e);
    }

    public void mousePressed(MouseEvent e) {
        this.evaluatePopup(e);
    }

    private void evaluatePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.createPopupMenu(this.columnAtPoint(e.getPoint())).show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createPopupMenu(int column) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.GUESS_TYPE_ACTION_24);
        menu.add(this.GUESS_ALL_TYPES_ACTION_24);
        menu.add(this.REMOVE_COLUMN_ACTION_24);
        menu.add(this.REMOVE_ROW_ACTION_24);
        menu.add(this.USE_ROW_AS_NAMES_ACTION_24);
        return menu;
    }

    public void useRowAsNames() {
        int row = this.getSelectedRow() - 5;
        if (row >= 0) {
            this.useRowAsNames(row);
        }
    }

    public void removeColumn() {
        int column = this.getSelectedColumn();
        if (column != -1) {
            this.removeColumn(column);
        }
    }

    public void removeColumn(int column) {
        this.sourceList.remove(column);
        this.dataColumnVector.removeElementAt(column);
        this.rowCount = 0;
        if (this.dataColumnVector.size() > 0) {
            this.rowCount = this.dataColumnVector.get(0).size();
        }
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.setMaxColumns(Math.max(0, this.dataControl.getMaxColumns() - 1));
        this.dataControl.update();
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    public void removeRow() {
        int row = this.getSelectedRow() - 5;
        if (row != -1) {
            this.removeRow(row);
        }
    }

    public void removeRow(int row) {
        if (this.rowCount == 0 || row < 0) {
            return;
        }
        for (Vector<String> c : this.dataColumnVector) {
            c.remove(row);
        }
        --this.rowCount;
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.update();
        this.dataChanged = true;
    }

    public void useRowAsNames(int row) {
        if (this.rowCount == 0 || row < 0) {
            return;
        }
        Iterator<Vector<String>> i = this.dataColumnVector.iterator();
        int column = 0;
        while (i.hasNext()) {
            Vector<String> c = i.next();
            String name = c.remove(row);
            this.setValueAt(name, 0, column);
            ++column;
        }
        --this.rowCount;
        this.dataControl.setMaxRows(this.rowCount);
        this.dataControl.update();
        this.dataChanged = true;
        this.metaDataChanged = true;
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<AttributeDataSource> columns = new LinkedList<AttributeDataSource>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<AttributeDataSource> i = this.sourceList.iterator();
        int j = 0;
        while (i.hasNext()) {
            AttributeDataSource source = i.next();
            if (source.getType() != null && source.getType().equals(type)) {
                columns.add(source);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] names = new String[columns.size()];
            i = columns.iterator();
            j = 0;
            while (i.hasNext()) {
                names[j++] = i.next().getAttribute().getName();
            }
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            String selection = (String)JOptionPane.showInputDialog(this, message, String.valueOf(type) + " multiply defined", 2, null, names, names[0]);
            if (selection != null) {
                i = columns.iterator();
                Iterator k = columnNumbers.iterator();
                while (i.hasNext()) {
                    AttributeDataSource source = i.next();
                    Integer number = (Integer)k.next();
                    if (source.getAttribute().getName().equals(selection)) continue;
                    source.setType("attribute");
                    this.model.fireTableCellUpdated(1, number);
                }
            }
        }
    }

    public void writeData(File file) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        PrintWriter out = new PrintWriter(new FileWriter(file));
        int i = 0;
        while (i < this.sourceList.size()) {
            AttributeDataSource source = this.sourceList.get(i);
            source.setSource(file, i);
            ++i;
        }
        int row = 0;
        while (row < this.rowCount) {
            int col = 0;
            while (col < this.sourceList.size()) {
                if (col != 0) {
                    out.print("\t");
                }
                out.print(this.getDatum(row, col));
                ++col;
            }
            out.println();
            ++row;
        }
        out.close();
        this.dataChanged = false;
    }

    public void openAttributeFile() {
        File file = SwingTools.chooseFile((Component)this, null, true, "aml", "attribute description file");
        if (file != null) {
            this.openAttributeFile(file);
        }
    }

    public void openAttributeFile(File file) {
        AttributeDataSources attributeDataSources = null;
        try {
            attributeDataSources = AttributeDataSource.createAttributeDataSources(file, true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Could not open '" + file + "':" + Tools.getLineSeparator() + e, "Error", 0);
            return;
        }
        this.file = file;
        this.clear();
        FileDataRowReader reader = null;
        try {
            reader = new FileDataRowReader(new DataRowFactory(0, this.exampleSource.getParameterAsString("decimal_point_character").charAt(0)), attributeDataSources.getDataSources(), 1.0, -1, this.exampleSource.getParameterAsString("column_separators"), this.exampleSource.getParameterAsString("comment_chars").toCharArray(), this.exampleSource.getParameterAsBoolean("use_quotes"), RandomGenerator.getRandomGenerator(-1));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Cannot open data file: " + e, "Error", 0);
            return;
        }
        catch (UndefinedParameterError e) {
            // empty catch block
        }
        this.sourceList.addAll(attributeDataSources.getDataSources());
        int j = 0;
        while (j < attributeDataSources.getDataSources().size()) {
            this.createNewColumn();
            ++j;
        }
        ExampleTable table = null;
        try {
            table = new MemoryExampleTable(new AttributeSet(attributeDataSources).getAllAttributes(), reader);
        }
        catch (UserError e) {
            SwingTools.showErrorMessage("Cannot load attribute descriptions.", e);
        }
        if (table != null) {
            Iterator e = table.createExampleSet().iterator();
            this.rowCount = 0;
            while (e.hasNext()) {
                Example example = (Example)e.next();
                Iterator<AttributeDataSource> adsIterator = this.sourceList.iterator();
                int n = 0;
                while (adsIterator.hasNext()) {
                    AttributeDataSource ads = adsIterator.next();
                    this.setDatum(this.rowCount, n++, example.getValueAsString(ads.getAttribute()));
                }
                ++this.rowCount;
            }
        }
        this.update();
        this.metaDataChanged = false;
        this.dataChanged = false;
    }

    public void saveAttributeFile() {
        int i = 1;
        while (i < Attributes.KNOWN_ATTRIBUTE_TYPES.length) {
            this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
            ++i;
        }
        File file = SwingTools.chooseFile((Component)this, null, false, "aml", "attribute description file");
        if (file != null) {
            this.file = file;
            try {
                this.writeXML(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.toString(), "Error saving attribute file " + file, 0);
            }
        }
        this.metaDataChanged = false;
    }

    private void writeXML(File attFile) throws IOException {
        if (this.sourceList.size() == 0) {
            return;
        }
        PrintWriter out = new PrintWriter(new FileWriter(attFile));
        File defaultSource = this.getDataSource(0).getFile();
        String relativePath = Tools.getRelativePath(defaultSource, attFile);
        out.println("<attributeset default_source=\"" + relativePath + "\">");
        Iterator<AttributeDataSource> i = this.sourceList.iterator();
        int c = 0;
        while (i.hasNext()) {
            AttributeDataSource ads = i.next();
            Attribute attribute = ads.getAttribute();
            if (attribute.isNominal()) {
                int r = 0;
                while (r < this.rowCount) {
                    attribute.getMapping().mapString(this.getDatum(r, c));
                    ++r;
                }
            }
            ads.writeXML(out, defaultSource);
            ++c;
        }
        out.println("</attributeset>");
        out.close();
    }

    public File getFile() {
        return this.file;
    }

    private void update() {
        this.dataControl.setFirstRow(1);
        this.dataControl.setLastRow(Math.min(this.dataControl.getMaxRows(), this.getDefaultMaximumNumber("rowlimit", this.dataControl.getMaxRows())));
        this.dataControl.setFirstColumn(1);
        this.dataControl.setLastColumn(Math.min(this.dataControl.getMaxColumns(), this.getDefaultMaximumNumber("columnlimit", this.dataControl.getMaxColumns())));
        this.dataControl.update();
    }

    public void update(int firstRow, int lastRow, int firstColumn, int lastColumn, int what) {
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstColumn = firstColumn;
        this.lastColumn = lastColumn;
        this.model.fireTableStructureChanged();
    }

    private class DataCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -7231941979925919248L;

        private DataCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!AttributeEditor.this.checkData(value, row, column)) {
                c.setBackground(Color.red);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }

    private class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 6911819468492570763L;

        private AttributeTableModel() {
        }

        public int getColumnCount() {
            return Math.min(AttributeEditor.this.sourceList.size(), AttributeEditor.this.lastColumn - (AttributeEditor.this.firstColumn - 1));
        }

        public int getRowCount() {
            return Math.min(AttributeEditor.this.rowCount, AttributeEditor.this.lastRow - (AttributeEditor.this.firstRow - 1)) + 5;
        }

        public String getColumnName(int _column) {
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            AttributeDataSource source = AttributeEditor.this.getDataSource(column);
            return String.valueOf(source.getFile().getName()) + " (" + (source.getColumn() + 1) + ")";
        }

        public Object getValueAt(int _row, int _column) {
            int row = _row;
            int column = _column + (AttributeEditor.this.firstColumn - 1);
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        return source.getAttribute().getName();
                    }
                    case 1: {
                        return source.getType();
                    }
                    case 2: {
                        return Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(source.getAttribute().getValueType());
                    }
                    case 3: {
                        return Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(source.getAttribute().getBlockType());
                    }
                    case 4: {
                        return null;
                    }
                }
                return "This cannot happen!";
            }
            row = _row + (AttributeEditor.this.firstRow - 1);
            return AttributeEditor.this.getDatum(row - 5, column);
        }

        public void setValueAt(Object value, int row, int column) {
            if (row < 5) {
                AttributeDataSource source = AttributeEditor.this.getDataSource(column);
                switch (row) {
                    case 0: {
                        source.getAttribute().setName((String)value);
                        break;
                    }
                    case 1: {
                        source.setType((String)value);
                        break;
                    }
                    case 2: {
                        source.setAttribute(AttributeFactory.changeValueType(source.getAttribute(), Ontology.ATTRIBUTE_VALUE_TYPE.mapName((String)value)));
                        break;
                    }
                    case 3: {
                        source.getAttribute().setBlockType(Ontology.ATTRIBUTE_BLOCK_TYPE.mapName((String)value));
                        break;
                    }
                }
            } else {
                AttributeEditor.this.setDatum(row - 5, column, (String)value);
            }
        }
    }
}

