/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.actions;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class ToggleExpertModeAction
extends AbstractAction {
    private static final long serialVersionUID = 5545547954042596599L;
    private static final String EXPERT_ICON_NAME = "graduate.png";
    private static final String BEGINNER_ICON_NAME = "user1.png";
    private static final Icon[] EXPERT_MODE_ICONS;
    private static final Icon[] BEGINNER_MODE_ICONS;
    private IconSize iconSize;
    private MainFrame mainFrame;

    static {
        IconSize size;
        EXPERT_MODE_ICONS = new Icon[IconSize.values().length];
        BEGINNER_MODE_ICONS = new Icon[IconSize.values().length];
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            size = iconSizeArray[n];
            ToggleExpertModeAction.EXPERT_MODE_ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + EXPERT_ICON_NAME);
            ++n;
        }
        counter = 0;
        iconSizeArray = IconSize.values();
        n = 0;
        n2 = iconSizeArray.length;
        while (n < n2) {
            size = iconSizeArray[n];
            ToggleExpertModeAction.BEGINNER_MODE_ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + BEGINNER_ICON_NAME);
            ++n;
        }
    }

    public ToggleExpertModeAction(MainFrame mainFrame, IconSize size) {
        super("Expert Mode");
        this.iconSize = size;
        this.putValue("ShortDescription", "Toggles between expert and beginner mode (changes the number of visible parameters)");
        this.putValue("MnemonicKey", 69);
        this.putValue("SmallIcon", EXPERT_MODE_ICONS[size.ordinal()]);
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        this.mainFrame.toggleExpertMode();
    }

    public void updateIcon() {
        if (this.mainFrame.getPropertyTable().isExpertMode()) {
            this.putValue("SmallIcon", BEGINNER_MODE_ICONS[this.iconSize.ordinal()]);
        } else {
            this.putValue("SmallIcon", EXPERT_MODE_ICONS[this.iconSize.ordinal()]);
        }
    }
}

