/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.actions;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.tools.jdbc.DatabaseService;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class CheckForJDBCDriversAction
extends AbstractAction {
    private static final long serialVersionUID = -3497263063489866721L;
    private static final String ICON_NAME = "data_connection.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private MainFrame mainFrame;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            IconSize size = iconSizeArray[n];
            CheckForJDBCDriversAction.ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + ICON_NAME);
            ++n;
        }
    }

    public CheckForJDBCDriversAction(MainFrame mainFrame, IconSize size) {
        super("Show Database Drivers...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "List all available JDBC database drivers which are currently available to YALE");
        this.putValue("MnemonicKey", 74);
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        StringBuffer titleString = new StringBuffer();
        String[] driverNames = DatabaseService.getAllDriverNames();
        titleString.append("<html>The currently available JDBC drivers are:<ul>");
        String[] stringArray = driverNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            titleString.append("<li>" + s + "</li>");
            ++n;
        }
        titleString.append("</ul>Please make sure to copy missing drivers into the directory lib/jdbc and restart YALE in order to make additional drivers available.</html>");
        JOptionPane.showMessageDialog(this.mainFrame, titleString.toString(), "List available database drivers", 1);
    }
}

