/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui.actions;

import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.attributeeditor.AttributeEditorDialog;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.io.ExampleSource;
import edu.udo.cs.yale.tools.OperatorService;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class AttributeEditorAction
extends AbstractAction {
    private static final long serialVersionUID = -1571544885210247278L;
    private static final String ICON_NAME = "table_new.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private MainFrame mainFrame;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = 0;
        int n2 = iconSizeArray.length;
        while (n < n2) {
            IconSize size = iconSizeArray[n];
            AttributeEditorAction.ICONS[counter++] = SwingTools.createIcon("icons/" + size.getSize() + "/" + ICON_NAME);
            ++n;
        }
    }

    public AttributeEditorAction(MainFrame mainFrame, IconSize size) {
        super("Attribute Editor...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Starts the Attribute Editor which can be used for the creation of XML meta data description files (.aml)");
        this.putValue("MnemonicKey", 65);
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ExampleSource exampleSource = (ExampleSource)OperatorService.createOperator("ExampleSource");
            AttributeEditorDialog dialog = new AttributeEditorDialog(this.mainFrame, exampleSource, null);
            dialog.setVisible(true);
        }
        catch (OperatorCreationException ex) {
            SwingTools.showVerySimpleErrorMessage("Cannot start attribute editor: not possible to create an ExampleSource operator!");
        }
    }
}

