/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.NoOpUserError;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.GUIInputHandler;
import edu.udo.cs.yale.gui.MainFrame;
import edu.udo.cs.yale.gui.ResultHistory;
import edu.udo.cs.yale.gui.dialog.TotDDialog;
import edu.udo.cs.yale.gui.dialog.WelcomeDialog;
import edu.udo.cs.yale.gui.tools.CheckForUpdatesThread;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YaleGUI
extends Yale {
    public static final String UPDATE_CHECK_NAME = "yale.gui.update.check";
    private static final int NUMBER_OF_RECENT_FILES = 8;
    private static MainFrame mainFrame;
    private static LinkedList<File> recentFiles;
    private static ResultHistory resultHistory;
    private static CheckForUpdatesThread updateCheckThread;

    static {
        Yale.registerYaleProperty(new ParameterTypeBoolean(UPDATE_CHECK_NAME, "Check for new Yale versions at start up time?", true));
        recentFiles = new LinkedList();
        resultHistory = new ResultHistory();
        updateCheckThread = null;
    }

    private static void setupGUI() throws NoOpUserError {
        try {
            Class<?> configurationClazz = Class.forName("com.Trendy.swing.plaf.TrendyConfiguration");
            Method antiAliasingMethod = configurationClazz.getMethod("setGlobal_ANTIALIASED_MINIMUM_FONT", Integer.class);
            antiAliasingMethod.invoke(null, 0);
            Field roundField = configurationClazz.getField("Component_RoundRect_Status");
            String roundString = (String)roundField.get(null);
            UIManager.put("Button." + roundString, -1);
            UIManager.put("ToggleButton." + roundString, -1);
            UIManager.put("ComboBox." + roundString, -1);
            Class<?> lookAndFeelClass = Class.forName("com.Trendy.swing.plaf.TrendyLookAndFeel");
            LookAndFeel laf = (LookAndFeel)lookAndFeelClass.newInstance();
            Class<?> themeClass = Class.forName("com.Trendy.swing.plaf.Themes.TrendyEnhancedDefaultTheme");
            Class<?> generalThemeClass = Class.forName("com.Trendy.swing.plaf.Themes.TrendyTheme");
            Method themeMethod = lookAndFeelClass.getMethod("setCurrentTheme", generalThemeClass);
            themeMethod.invoke((Object)laf, themeClass.newInstance());
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            LogService.logMessage("Cannot setup YALE look and feel, using system default.", 3);
        }
        ToolTipManager manager = ToolTipManager.sharedInstance();
        manager.setDismissDelay(25000);
        manager.setInitialDelay(1500);
        manager.setReshowDelay(50);
    }

    public void run(File file) throws Exception {
        URL logoURL = Tools.getResource("yale_logo_java.gif");
        if (logoURL == null) {
            System.err.println("ERROR: cannot find resources. Probably the ant target 'copy-resources' must be performed!");
            YaleGUI.quit(1);
        }
        YaleGUI.showSplash();
        YaleGUI.init();
        YaleGUI.splashMessage("Setting up Look and Feel");
        YaleGUI.setupGUI();
        YaleGUI.splashMessage("Loading History");
        YaleGUI.loadRecentFileList();
        YaleGUI.splashMessage("Creating Frame");
        YaleGUI.setMainFrame(new MainFrame());
        LogService.initGUI();
        YaleGUI.splashMessage("Ready.");
        YaleGUI.loadGUIProperties(mainFrame);
        mainFrame.setVisible(true);
        YaleGUI.hideSplash();
        String tipProperty = System.getProperty("yale.gui.tip.show");
        if (Tools.booleanValue(tipProperty, false)) {
            new TotDDialog(mainFrame).setVisible(true);
        }
        if (file != null) {
            mainFrame.open(file);
        } else {
            new WelcomeDialog(mainFrame).setVisible(true);
        }
        String updateProperty = System.getProperty(UPDATE_CHECK_NAME);
        if (Tools.booleanValue(updateProperty, true)) {
            boolean check = true;
            Calendar lastCheck = YaleGUI.loadLastUpdateCheckDate();
            if (lastCheck != null) {
                Calendar currentDate = Calendar.getInstance();
                currentDate.add(6, -7);
                if (!lastCheck.before(currentDate)) {
                    check = false;
                }
            }
            if (check) {
                YaleGUI.checkForUpdates(false);
            }
        }
    }

    public static void setMainFrame(MainFrame mf) {
        mainFrame = mf;
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        File file = null;
        if (args.length > 0) {
            if (args.length != 1) {
                System.out.println("java " + YaleGUI.class.getName() + " [experimentfile]");
                return;
            }
            file = new File(args[0]);
            if (!file.exists()) {
                System.err.println("File '" + args[0] + "' not found.");
                return;
            }
            if (!file.canRead()) {
                System.err.println("Cannot read file '" + args[0] + "'.");
                return;
            }
        }
        YaleGUI.setInputHandler(new GUIInputHandler());
        new YaleGUI().run(file);
    }

    public static void useExperimentFile(Experiment experiment) {
        File file = experiment.getExperimentFile();
        if (recentFiles.contains(file = new File(file.getAbsolutePath()))) {
            recentFiles.remove(file);
        }
        recentFiles.addFirst(file);
        while (recentFiles.size() > 8) {
            recentFiles.removeLast();
        }
    }

    public static ResultHistory getResultHistory() {
        return resultHistory;
    }

    public static List<File> getRecentFiles() {
        return recentFiles;
    }

    private static void loadRecentFileList() {
        try {
            File file = ParameterService.getUserConfigFile("history");
            if (!file.exists()) {
                return;
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            recentFiles.clear();
            String line = null;
            while ((line = in.readLine()) != null) {
                recentFiles.add(new File(line));
            }
            in.close();
        }
        catch (IOException e) {
            SwingTools.showErrorMessage("Cannot read history file", e);
        }
    }

    private static void saveRecentFileList() {
        try {
            File file = ParameterService.getUserConfigFile("history");
            PrintWriter out = new PrintWriter(new FileWriter(file));
            Iterator i = recentFiles.iterator();
            while (i.hasNext()) {
                out.println(((File)i.next()).getAbsolutePath());
            }
            out.close();
        }
        catch (IOException e) {
            SwingTools.showErrorMessage("Cannot write history file", e);
        }
    }

    public static void saveLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            Calendar currentDate = Calendar.getInstance();
            out.println(currentDate.get(1));
            out.println(currentDate.get(2));
            out.println(currentDate.get(5));
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Calendar loadLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String yearLine = in.readLine();
            String monthLine = in.readLine();
            String dayLine = in.readLine();
            in.close();
            int year = 2001;
            if (yearLine != null) {
                year = Integer.parseInt(yearLine.trim());
            }
            int month = 1;
            if (monthLine != null) {
                month = Integer.parseInt(monthLine.trim());
            }
            int day = 1;
            if (dayLine != null) {
                day = Integer.parseInt(dayLine.trim());
            }
            Calendar lastCheck = Calendar.getInstance();
            lastCheck.set(1, year);
            lastCheck.set(2, month);
            lastCheck.set(5, day);
            return lastCheck;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkForUpdates(boolean showFailureDialog) {
        updateCheckThread = new CheckForUpdatesThread(YaleGUI.getMainFrame(), showFailureDialog);
        updateCheckThread.start();
    }

    private static void saveGUIProperties() {
        Properties properties = new Properties();
        MainFrame mainFrame = YaleGUI.getMainFrame();
        if (mainFrame != null) {
            properties.setProperty("yale.gui.geometry.x", "" + (int)mainFrame.getLocation().getX());
            properties.setProperty("yale.gui.geometry.y", "" + (int)mainFrame.getLocation().getY());
            properties.setProperty("yale.gui.geometry.width", "" + mainFrame.getWidth());
            properties.setProperty("yale.gui.geometry.height", "" + mainFrame.getHeight());
            properties.setProperty("yale.gui.geometry.divider.main", "" + mainFrame.getMainDividerLocation());
            properties.setProperty("yale.gui.geometry.divider.editor", "" + mainFrame.getEditorDividerLocation());
            properties.setProperty("yale.gui.geometry.divider.logging", "" + mainFrame.getLoggingDividerLocation());
            properties.setProperty("yale.gui.geometry.divider.groupselection", "" + mainFrame.getGroupSelectionDividerLocation());
            properties.setProperty("yale.gui.expertmode", "" + mainFrame.getPropertyTable().isExpertMode());
            File file = ParameterService.getUserConfigFile("gui.properties");
            try {
                FileOutputStream out = new FileOutputStream(file);
                properties.store(out, "Yale GUI properties");
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadGUIProperties(MainFrame mainFrame) {
        Properties properties = new Properties();
        File file = ParameterService.getUserConfigFile("gui.properties");
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                properties.load(in);
                ((InputStream)in).close();
            }
            catch (IOException e) {
                YaleGUI.setDefaultGUIProperties();
            }
            try {
                mainFrame.setLocation(Integer.parseInt(properties.getProperty("yale.gui.geometry.x")), Integer.parseInt(properties.getProperty("yale.gui.geometry.y")));
                mainFrame.setSize(new Dimension(Integer.parseInt(properties.getProperty("yale.gui.geometry.width")), Integer.parseInt(properties.getProperty("yale.gui.geometry.height"))));
                mainFrame.setDividerLocations(Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.main")), Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.editor")), Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.logging")), Integer.parseInt(properties.getProperty("yale.gui.geometry.divider.groupselection")));
                mainFrame.getPropertyTable().setExpertMode(Boolean.valueOf(properties.getProperty("yale.gui.expertmode")));
                mainFrame.updateToggleExpertModeIcon();
            }
            catch (NumberFormatException e) {
                YaleGUI.setDefaultGUIProperties();
            }
        } else {
            YaleGUI.setDefaultGUIProperties();
        }
    }

    private static void setDefaultGUIProperties() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        mainFrame.setLocation((int)(0.05 * screenSize.getWidth()), (int)(0.05 * screenSize.getHeight()));
        mainFrame.setSize((int)(0.9 * screenSize.getWidth()), (int)(0.9 * screenSize.getHeight()));
        mainFrame.setDividerLocations((int)(0.6 * screenSize.getHeight()), (int)(0.2 * screenSize.getWidth()), (int)(0.75 * screenSize.getWidth()), (int)(0.4 * screenSize.getWidth()));
        mainFrame.getPropertyTable().setExpertMode(false);
        mainFrame.updateToggleExpertModeIcon();
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            LogService.logMessage("Running shutdown sequence.", 3);
            YaleGUI.saveRecentFileList();
            YaleGUI.saveGUIProperties();
        }
    }
}

