/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import de.java.print.PreviewDialog;
import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.ConditionalAction;
import edu.udo.cs.yale.gui.ExperimentThread;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.actions.AnovaCalculatorAction;
import edu.udo.cs.yale.gui.actions.AttributeDescriptionFileWizardAction;
import edu.udo.cs.yale.gui.actions.AttributeEditorAction;
import edu.udo.cs.yale.gui.actions.BoxViewerAction;
import edu.udo.cs.yale.gui.actions.CheckForJDBCDriversAction;
import edu.udo.cs.yale.gui.actions.CheckForUpdatesAction;
import edu.udo.cs.yale.gui.actions.EditModeAction;
import edu.udo.cs.yale.gui.actions.ExitAction;
import edu.udo.cs.yale.gui.actions.ExportAction;
import edu.udo.cs.yale.gui.actions.ManageBuildingBlocksAction;
import edu.udo.cs.yale.gui.actions.ManageTemplatesAction;
import edu.udo.cs.yale.gui.actions.NewAction;
import edu.udo.cs.yale.gui.actions.OpenAction;
import edu.udo.cs.yale.gui.actions.PageSetupAction;
import edu.udo.cs.yale.gui.actions.PrintAction;
import edu.udo.cs.yale.gui.actions.PrintPreviewAction;
import edu.udo.cs.yale.gui.actions.RedoAction;
import edu.udo.cs.yale.gui.actions.ResultHistoryAction;
import edu.udo.cs.yale.gui.actions.ResultsModeAction;
import edu.udo.cs.yale.gui.actions.RunResumeAction;
import edu.udo.cs.yale.gui.actions.SaveAction;
import edu.udo.cs.yale.gui.actions.SaveAsAction;
import edu.udo.cs.yale.gui.actions.SaveAsTemplateAction;
import edu.udo.cs.yale.gui.actions.SettingsAction;
import edu.udo.cs.yale.gui.actions.StopAction;
import edu.udo.cs.yale.gui.actions.ToggleExpertModeAction;
import edu.udo.cs.yale.gui.actions.ToggleLoggingViewerItem;
import edu.udo.cs.yale.gui.actions.ToggleSystemMonitorItem;
import edu.udo.cs.yale.gui.actions.TotDAction;
import edu.udo.cs.yale.gui.actions.TutorialAction;
import edu.udo.cs.yale.gui.actions.UndoAction;
import edu.udo.cs.yale.gui.actions.ValidateExperimentAction;
import edu.udo.cs.yale.gui.actions.WizardAction;
import edu.udo.cs.yale.gui.dialog.AboutBox;
import edu.udo.cs.yale.gui.dialog.Browser;
import edu.udo.cs.yale.gui.dialog.ExperimentInfoScreen;
import edu.udo.cs.yale.gui.dialog.Tutorial;
import edu.udo.cs.yale.gui.experimenteditor.MainExperimentEditor;
import edu.udo.cs.yale.gui.experimenteditor.ResultDisplay;
import edu.udo.cs.yale.gui.operatortree.OperatorTree;
import edu.udo.cs.yale.gui.properties.OperatorPropertyTable;
import edu.udo.cs.yale.gui.templates.SaveAsTemplateDialog;
import edu.udo.cs.yale.gui.templates.Template;
import edu.udo.cs.yale.gui.tools.ComponentPrinter;
import edu.udo.cs.yale.gui.tools.ExtendedToolBar;
import edu.udo.cs.yale.gui.tools.IconSize;
import edu.udo.cs.yale.gui.tools.LoggingViewer;
import edu.udo.cs.yale.gui.tools.StatusBar;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.gui.tools.SystemMonitor;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.freehep.util.export.ExportDialog;

public class MainFrame
extends JFrame
implements WindowListener,
BreakpointListener {
    private static final long serialVersionUID = -1602076945350148969L;
    private static final String HISTORY_ICON_NAME = "icons/24/history2.png";
    private static final String ABOUT_ICON_NAME = "icons/24/about.png";
    private static final String HELP_ICON_NAME = "icons/24/help2.png";
    private static final String PLUGINS_ICON_NAME = "icons/24/plug.png";
    private static final String YALE_LOGO_NAME = "yale_logo.gif";
    private static Icon historyIcon = null;
    private static Icon aboutIcon = null;
    private static Icon helpIcon = null;
    private static Icon pluginsIcon = null;
    private static Image[] yaleLogos = new Image[0];
    public static final String TITLE = "YALE";
    public static final int EDIT_MODE = 0;
    public static final int RESULTS_MODE = 1;
    public static final String EDIT_MODE_NAME = "edit";
    public static final String RESULTS_MODE_NAME = "results";
    public final Action NEW_ACTION_24 = new NewAction(this, IconSize.SMALL);
    public final Action NEW_ACTION_32 = new NewAction(this, IconSize.MIDDLE);
    public final Action OPEN_ACTION_24 = new OpenAction(this, IconSize.SMALL);
    public final Action OPEN_ACTION_32 = new OpenAction(this, IconSize.MIDDLE);
    public final Action SAVE_ACTION_24 = new SaveAction(this, IconSize.SMALL);
    public final Action SAVE_ACTION_32 = new SaveAction(this, IconSize.MIDDLE);
    public final Action SAVE_AS_ACTION_24 = new SaveAsAction(this, IconSize.SMALL);
    public final Action SAVE_AS_ACTION_32 = new SaveAsAction(this, IconSize.MIDDLE);
    public final Action SAVE_AS_TEMPLATE_ACTION_24 = new SaveAsTemplateAction(this, IconSize.SMALL);
    public final Action SAVE_AS_TEMPLATE_ACTION_32 = new SaveAsTemplateAction(this, IconSize.MIDDLE);
    public final Action MANAGE_TEMPLATES_ACTION_24 = new ManageTemplatesAction(this, IconSize.SMALL);
    public final Action MANAGE_TEMPLATES_ACTION_32 = new ManageTemplatesAction(this, IconSize.MIDDLE);
    public final Action MANAGE_BUILDING_BLOCKS_ACTION_24 = new ManageBuildingBlocksAction(this, IconSize.SMALL);
    public final Action MANAGE_BUILDING_BLOCKS_ACTION_32 = new ManageBuildingBlocksAction(this, IconSize.MIDDLE);
    public final Action PRINT_ACTION_24 = new PrintAction(this, IconSize.SMALL);
    public final Action PRINT_ACTION_32 = new PrintAction(this, IconSize.MIDDLE);
    public final Action PRINT_PREVIEW_ACTION_24 = new PrintPreviewAction(this, IconSize.SMALL);
    public final Action PRINT_PREVIEW_ACTION_32 = new PrintPreviewAction(this, IconSize.MIDDLE);
    public final Action PAGE_SETUP_ACTION_24 = new PageSetupAction(this, IconSize.SMALL);
    public final Action PAGE_SETUP_ACTION_32 = new PageSetupAction(this, IconSize.MIDDLE);
    public final Action EXPORT_ACTION_24 = new ExportAction(this, IconSize.SMALL);
    public final Action EXPORT_ACTION_32 = new ExportAction(this, IconSize.MIDDLE);
    public final Action EXIT_ACTION_24 = new ExitAction(this, IconSize.SMALL);
    public final Action EXIT_ACTION_32 = new ExitAction(this, IconSize.MIDDLE);
    public final RunResumeAction RUN_RESUME_ACTION_24 = new RunResumeAction(this, IconSize.SMALL);
    public final RunResumeAction RUN_RESUME_ACTION_32 = new RunResumeAction(this, IconSize.MIDDLE);
    public final Action STOP_ACTION_24 = new StopAction(this, IconSize.SMALL);
    public final Action STOP_ACTION_32 = new StopAction(this, IconSize.MIDDLE);
    public final Action VALIDATE_ACTION_24 = new ValidateExperimentAction(this, IconSize.SMALL);
    public final Action VALIDATE_ACTION_32 = new ValidateExperimentAction(this, IconSize.MIDDLE);
    public final Action WIZARD_ACTION_24 = new WizardAction(this, IconSize.SMALL);
    public final Action WIZARD_ACTION_32 = new WizardAction(this, IconSize.MIDDLE);
    public final Action SETTINGS_ACTION_24 = new SettingsAction(this, IconSize.SMALL);
    public final Action SETTINGS_ACTION_32 = new SettingsAction(this, IconSize.MIDDLE);
    public final Action TOGGLE_EXPERT_MODE_ACTION_24 = new ToggleExpertModeAction(this, IconSize.SMALL);
    public final Action TOGGLE_EXPERT_MODE_ACTION_32 = new ToggleExpertModeAction(this, IconSize.MIDDLE);
    public final Action TUTORIAL_ACTION_24 = new TutorialAction(this, IconSize.SMALL);
    public final Action TUTORIAL_ACTION_32 = new TutorialAction(this, IconSize.MIDDLE);
    public final Action TOTD_ACTION_24 = new TotDAction(this, IconSize.SMALL);
    public final Action TOTD_ACTION_32 = new TotDAction(this, IconSize.MIDDLE);
    public final Action UNDO_ACTION_24 = new UndoAction(this, IconSize.SMALL);
    public final Action UNDO_ACTION_32 = new UndoAction(this, IconSize.MIDDLE);
    public final Action REDO_ACTION_24 = new RedoAction(this, IconSize.SMALL);
    public final Action REDO_ACTION_32 = new RedoAction(this, IconSize.MIDDLE);
    public final Action ATTRIBUTE_EDITOR_ACTION_24 = new AttributeEditorAction(this, IconSize.SMALL);
    public final Action ATTRIBUTE_EDITOR_ACTION_32 = new AttributeEditorAction(this, IconSize.MIDDLE);
    public final Action ANOVA_CALCULATOR_ACTION_24 = new AnovaCalculatorAction(this, IconSize.SMALL);
    public final Action ANOVA_CALCULATOR_ACTION_32 = new AnovaCalculatorAction(this, IconSize.MIDDLE);
    public final Action CHECK_FOR_UPDATES_ACTION_24 = new CheckForUpdatesAction(IconSize.SMALL);
    public final Action CHECK_FOR_UPDATES_ACTION_32 = new CheckForUpdatesAction(IconSize.MIDDLE);
    public final Action CHECK_FOR_JDBC_DRIVERS_ACTION_24 = new CheckForJDBCDriversAction(this, IconSize.SMALL);
    public final Action CHECK_FOR_JDBC_DRIVERS_ACTION_32 = new CheckForJDBCDriversAction(this, IconSize.MIDDLE);
    public final Action EDIT_MODE_24 = new EditModeAction(this, IconSize.SMALL);
    public final Action EDIT_MODE_32 = new EditModeAction(this, IconSize.MIDDLE);
    public final Action RESULTS_MODE_24 = new ResultsModeAction(this, IconSize.SMALL);
    public final Action RESULTS_MODE_32 = new ResultsModeAction(this, IconSize.MIDDLE);
    public final Action BOX_VIEW_24 = new BoxViewerAction(this, IconSize.SMALL);
    public final Action BOX_VIEW_32 = new BoxViewerAction(this, IconSize.MIDDLE);
    public final Action RESULT_HISTORY_24 = new ResultHistoryAction(this, IconSize.SMALL);
    public final Action RESULT_HISTORY_32 = new ResultHistoryAction(this, IconSize.MIDDLE);
    public final Action ATTRIBUTE_DESCRIPTION_FILE_WIZARD_24 = new AttributeDescriptionFileWizardAction(IconSize.SMALL);
    public final Action ATTRIBUTE_DESCRIPTION_FILE_WIZARD_32 = new AttributeDescriptionFileWizardAction(IconSize.MIDDLE);
    public final JCheckBoxMenuItem TOGGLE_LOGGING_VIEWER = new ToggleLoggingViewerItem(this, IconSize.SMALL);
    public final JCheckBoxMenuItem TOGGLE_SYSTEM_MONITOR = new ToggleSystemMonitorItem(this, IconSize.SMALL);
    private CardLayout mainCardLayout = new CardLayout();
    private JPanel mainPanel = new JPanel(this.mainCardLayout);
    private ResultDisplay resultDisplay = new ResultDisplay();
    private LoggingViewer messageViewer = new LoggingViewer();
    private SystemMonitor systemMonitor = new SystemMonitor();
    private StatusBar statusBar = new StatusBar();
    private MainExperimentEditor mainEditor = new MainExperimentEditor(this);
    private JToolBar toolBar = new ExtendedToolBar();
    private JSplitPane splitPaneV;
    private JSplitPane loggingSplitPaneH;
    private int lastLoggingDividerLocation = -1;
    private int lastMonitorDividerLocation = -1;
    private int currentMode = 0;
    private JMenu recentFilesMenu = new JMenu("Recent Files");
    private transient PrinterJob printerJob = PrinterJob.getPrinterJob();
    private transient PageFormat pageFormat = this.printerJob.defaultPage();
    private boolean changed = false;
    private boolean tutorialMode = false;
    private LinkedList<String> undoList = new LinkedList();
    private int undoIndex;
    private String hostname = null;
    private transient Experiment experiment = null;
    private transient ExperimentThread experimentThread;

    static {
        historyIcon = SwingTools.createIcon(HISTORY_ICON_NAME);
        aboutIcon = SwingTools.createIcon(ABOUT_ICON_NAME);
        helpIcon = SwingTools.createIcon(HELP_ICON_NAME);
        pluginsIcon = SwingTools.createIcon(PLUGINS_ICON_NAME);
        URL url = Tools.getResource(YALE_LOGO_NAME);
        if (url != null) {
            try {
                yaleLogos = new Image[]{ImageIO.read(url)};
            }
            catch (IOException e) {
                yaleLogos = new Image[0];
            }
        } else {
            yaleLogos = new Image[0];
        }
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.fractiondigits.numbers", "The number of fraction digits of formatted numbers.", 0, Integer.MAX_VALUE, 3));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.fractiondigits.percent", "The number of fraction digits of formatted percent values.", 0, Integer.MAX_VALUE, 2));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.plotter.matrixplot.size", "The pixel size of each plot in matrix plots.", 1, Integer.MAX_VALUE, 200));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.plotter.rows.maximum", "The maximum number of rows used for a plotter, using only a sample of this size if more rows are available.", 1, Integer.MAX_VALUE, 1000));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.plotter.legend.classlimit", "Limit number of displayed classes plotter legends. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.plotter.legend.mincolor", "The color for minimum values of the plotter legend.", Color.blue));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.plotter.legend.maxcolor", "The color for maximum values of the plotter legend.", Color.red));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.plotter.colors.classlimit", "Limit number of displayed classes for colorized plots. -1 for no limit.", -1, Integer.MAX_VALUE, 10));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.undolist.size", "Maximum number of states in the undo list.", 1, Integer.MAX_VALUE, 10));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.attributeeditor.rowlimit", "Maximum number of examples to use for the attribute editor. -1 for no limit.", -1, Integer.MAX_VALUE, 50));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.success", "Beep on experiment success?", false));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.error", "Beep on error?", false));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.beep.breakpoint", "Beep when breakpoint reached?", false));
        Yale.registerYaleProperty(new ParameterTypeInt("yale.gui.messageviewer.rowlimit", "Limit number of displayed rows in the message viewer. -1 for no limit.", -1, Integer.MAX_VALUE, 1000));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.messageviewer.highlight.warnings", "The color for warnings in the message viewer.", Color.blue));
        Yale.registerYaleProperty(new ParameterTypeColor("yale.gui.messageviewer.highlight.errors", "The color for errors in the message viewer.", Color.red));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.experimentinfo.show", "Shows experiment info screen after loading?", true));
        Yale.registerYaleProperty(new ParameterTypeBoolean("yale.gui.tip.show", "Show Tip of the Day at start up time?", true));
    }

    public MainFrame() {
        super(TITLE);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        try {
            URL url = Tools.getResource(YALE_LOGO_NAME);
            if (url != null) {
                this.setIconImage(ImageIO.read(url));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setExperiment(new Experiment());
        this.mainPanel.setBorder(null);
        this.mainPanel.add((Component)this.mainEditor, EDIT_MODE_NAME);
        this.mainPanel.add((Component)this.resultDisplay, RESULTS_MODE_NAME);
        this.mainEditor.setBorder(null);
        this.resultDisplay.setBorder(null);
        this.systemMonitor.setBorder(BorderFactory.createEtchedBorder());
        this.loggingSplitPaneH = new JSplitPane(1, this.messageViewer, this.systemMonitor);
        this.loggingSplitPaneH.setBorder(null);
        this.loggingSplitPaneH.setResizeWeight(1.0);
        this.systemMonitor.startMonitorThread();
        this.splitPaneV = new JSplitPane(0, this.mainPanel, this.loggingSplitPaneH);
        this.splitPaneV.setBorder(null);
        this.splitPaneV.setResizeWeight(1.0);
        this.splitPaneV.setBorder(null);
        this.getContentPane().add((Component)this.splitPaneV, "Center");
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.NEW_ACTION_24);
        fileMenu.add(this.WIZARD_ACTION_24);
        fileMenu.add(this.OPEN_ACTION_24);
        this.updateRecentFileList();
        this.recentFilesMenu.setIcon(historyIcon);
        fileMenu.add(this.recentFilesMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.SAVE_ACTION_24);
        fileMenu.add(this.SAVE_AS_ACTION_24);
        fileMenu.add(this.SAVE_AS_TEMPLATE_ACTION_24);
        fileMenu.addSeparator();
        fileMenu.add(this.PRINT_ACTION_24);
        fileMenu.add(this.PRINT_PREVIEW_ACTION_24);
        fileMenu.add(this.PAGE_SETUP_ACTION_24);
        fileMenu.add(this.EXPORT_ACTION_24);
        fileMenu.addSeparator();
        fileMenu.add(this.EXIT_ACTION_24);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        editMenu.add(this.UNDO_ACTION_24);
        editMenu.add(this.REDO_ACTION_24);
        editMenu.addSeparator();
        editMenu.add(this.mainEditor.getOperatorTree().NEW_OPERATOR_ACTION_24);
        editMenu.add(this.mainEditor.getOperatorTree().NEW_BUILDING_BLOCK_ACTION_24);
        editMenu.addSeparator();
        this.mainEditor.getOperatorTree().addOperatorMenuItems(editMenu);
        menuBar.add(editMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        viewMenu.add(this.EDIT_MODE_24);
        viewMenu.add(this.RESULTS_MODE_24);
        viewMenu.addSeparator();
        viewMenu.add(this.TOGGLE_EXPERT_MODE_ACTION_24);
        viewMenu.addSeparator();
        viewMenu.add(this.BOX_VIEW_24);
        viewMenu.add(this.RESULT_HISTORY_24);
        viewMenu.addSeparator();
        viewMenu.add(this.TOGGLE_LOGGING_VIEWER);
        viewMenu.add(this.TOGGLE_SYSTEM_MONITOR);
        menuBar.add(viewMenu);
        JMenu expMenu = new JMenu("Experiment");
        expMenu.setMnemonic(88);
        expMenu.add(this.RUN_RESUME_ACTION_24);
        expMenu.add(this.STOP_ACTION_24);
        menuBar.add(expMenu);
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        toolsMenu.add(this.VALIDATE_ACTION_24);
        toolsMenu.add(this.mainEditor.getOperatorTree().INFO_OPERATOR_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.ATTRIBUTE_DESCRIPTION_FILE_WIZARD_24);
        toolsMenu.add(this.ATTRIBUTE_EDITOR_ACTION_24);
        toolsMenu.add(this.ANOVA_CALCULATOR_ACTION_24);
        toolsMenu.add(this.messageViewer.CLEAR_MESSAGE_VIEWER_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.MANAGE_TEMPLATES_ACTION_24);
        toolsMenu.add(this.MANAGE_BUILDING_BLOCKS_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.CHECK_FOR_UPDATES_ACTION_24);
        toolsMenu.addSeparator();
        toolsMenu.add(this.CHECK_FOR_JDBC_DRIVERS_ACTION_24);
        toolsMenu.add(this.SETTINGS_ACTION_24);
        menuBar.add(toolsMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem aboutItem = new JMenuItem("About Yale...", aboutIcon);
        aboutItem.setMnemonic(89);
        aboutItem.setToolTipText("Display information about Yale");
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AboutBox(MainFrame.this, MainFrame.TITLE, Yale.getVersion(), "YALE - Yet Another Learning Environment" + Tools.getLineSeparator() + "Copyright (C) 2001-2006" + Tools.getLineSeparator() + "Project administrator: Ingo Mierswa" + Tools.getLineSeparator() + "YALE was mainly written by members of the" + Tools.getLineSeparator() + "Artificial Intelligence Unit, Computer Science Department, University of Dortmund, 44221 Dortmund, Germany." + Tools.getLineSeparator() + "Complete list of developers available at our web site:" + Tools.getLineSeparator() + Tools.getLineSeparator() + "         http://yale.sf.net/" + Tools.getLineSeparator() + Tools.getLineSeparator() + "Yale comes with ABSOLUTELY NO WARRANTY; This is free software," + "and you are welcome to redistribute it under certain conditions;" + "see license information in the file named LICENSE.", yaleLogos).setVisible(true);
            }
        });
        helpMenu.add(aboutItem);
        helpMenu.add(this.TOTD_ACTION_24);
        helpMenu.add(this.TUTORIAL_ACTION_24);
        JMenuItem contents = new JMenuItem("Yale GUI Manual...", helpIcon);
        contents.setMnemonic(77);
        contents.setToolTipText("Browse the Yale GUI Manual.");
        contents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URL manualResource = Tools.getResource("manual/YaleGUIManual.html");
                if (manualResource != null) {
                    Browser.showDialog(manualResource);
                } else {
                    SwingTools.showVerySimpleErrorMessage("Cannot load GUI manual: file not found.");
                }
            }
        });
        helpMenu.add(contents);
        List allPlugins = Plugin.getAllPlugins();
        if (allPlugins.size() > 0) {
            helpMenu.addSeparator();
            for (final Plugin plugin : allPlugins) {
                JMenuItem aboutPluginItem = new JMenuItem("About " + plugin.getName() + "...", pluginsIcon);
                aboutPluginItem.setToolTipText("Display information about " + plugin.getName());
                aboutPluginItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        plugin.createAboutBox(MainFrame.this).setVisible(true);
                    }
                });
                helpMenu.add(aboutPluginItem);
            }
        }
        menuBar.add(helpMenu);
        this.toolBar.add(this.NEW_ACTION_32);
        this.toolBar.add(this.OPEN_ACTION_32);
        this.toolBar.add(this.SAVE_ACTION_32);
        this.toolBar.add(this.SAVE_AS_ACTION_32);
        this.toolBar.add(this.PRINT_ACTION_32);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.UNDO_ACTION_32);
        this.toolBar.add(this.REDO_ACTION_32);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.mainEditor.getOperatorTree().NEW_OPERATOR_ACTION_32);
        this.toolBar.add(this.mainEditor.getOperatorTree().DELETE_OPERATOR_ACTION_32);
        this.toolBar.add(this.mainEditor.getOperatorTree().NEW_BUILDING_BLOCK_ACTION_32);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.RUN_RESUME_ACTION_32);
        this.toolBar.add(this.STOP_ACTION_32);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.VALIDATE_ACTION_32);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.toolBar.add(this.TOGGLE_EXPERT_MODE_ACTION_32);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.add(this.EDIT_MODE_32);
        this.toolBar.add(this.RESULTS_MODE_32);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statusBar.startClockThread();
        this.addToUndoList();
        this.enableActions();
        this.pack();
        this.changeMode(0);
    }

    public Object readResolve() {
        this.printerJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printerJob.defaultPage();
        return this;
    }

    public void changeMode(int mode) {
        this.currentMode = mode;
        switch (this.currentMode) {
            case 0: {
                this.mainCardLayout.show(this.mainPanel, EDIT_MODE_NAME);
                this.EDIT_MODE_24.setEnabled(false);
                this.EDIT_MODE_32.setEnabled(false);
                this.RESULTS_MODE_24.setEnabled(true);
                this.RESULTS_MODE_32.setEnabled(true);
                break;
            }
            case 1: {
                this.mainCardLayout.show(this.mainPanel, RESULTS_MODE_NAME);
                this.EDIT_MODE_24.setEnabled(true);
                this.EDIT_MODE_32.setEnabled(true);
                this.RESULTS_MODE_24.setEnabled(false);
                this.RESULTS_MODE_32.setEnabled(false);
            }
        }
    }

    public void startTutorial() {
        if (this.close()) {
            new Tutorial(this).setVisible(true);
        }
    }

    public void setTutorialMode(boolean mode) {
        this.tutorialMode = mode;
        if (this.tutorialMode) {
            this.SAVE_ACTION_24.setEnabled(false);
            this.SAVE_ACTION_32.setEnabled(false);
            this.SAVE_AS_ACTION_24.setEnabled(false);
            this.SAVE_AS_ACTION_32.setEnabled(false);
        } else {
            this.SAVE_ACTION_24.setEnabled(false);
            this.SAVE_ACTION_32.setEnabled(false);
            this.SAVE_AS_ACTION_24.setEnabled(true);
            this.SAVE_AS_ACTION_32.setEnabled(true);
        }
    }

    public boolean isTutorialMode() {
        return this.tutorialMode;
    }

    public void setSystemMonitor(SystemMonitor newSystemMonitor) {
        this.loggingSplitPaneH.remove(this.systemMonitor);
        this.systemMonitor = newSystemMonitor;
        this.systemMonitor.setBorder(BorderFactory.createEtchedBorder());
        this.loggingSplitPaneH.add(newSystemMonitor);
    }

    public void print() {
        switch (this.currentMode) {
            case 0: {
                this.printerJob.setPrintable(new ComponentPrinter(this.mainEditor));
                break;
            }
            case 1: {
                this.printerJob.setPrintable(new ComponentPrinter(this.resultDisplay));
            }
        }
        if (this.printerJob.printDialog()) {
            try {
                this.printerJob.print();
            }
            catch (PrinterException pe) {
                SwingTools.showSimpleErrorMessage("Printer error", pe);
            }
        }
    }

    public void printPreview() {
        Component[] dialogComponents;
        ComponentPrinter printer = null;
        switch (this.currentMode) {
            case 0: {
                printer = new ComponentPrinter(this.mainEditor);
                break;
            }
            case 1: {
                printer = new ComponentPrinter(this.resultDisplay);
            }
        }
        PreviewDialog dialog = new PreviewDialog("Print Preview", (JFrame)this, (Printable)printer, this.pageFormat, 1);
        Component[] componentArray = dialogComponents = dialog.getContentPane().getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component c = componentArray[n];
            if (c instanceof JToolBar) {
                ((JToolBar)c).setFloatable(false);
            }
            ++n;
        }
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this);
        dialog.setVisible(true);
    }

    public void pageSetup() {
        this.pageFormat = this.printerJob.pageDialog(this.pageFormat);
    }

    public void export() {
        ExportDialog exportDialog = new ExportDialog(TITLE);
        switch (this.currentMode) {
            case 0: {
                exportDialog.showExportDialog((Component)this, "Export", (Component)this.getOperatorTree(), this.getBaseName());
                break;
            }
            case 1: {
                exportDialog.showExportDialog((Component)this, "Export", (Component)this.resultDisplay, this.getBaseName());
            }
        }
    }

    public int getEditorDividerLocation() {
        return this.mainEditor.getDividerLocation();
    }

    public int getGroupSelectionDividerLocation() {
        return this.mainEditor.getGroupSelectionDivider();
    }

    public int getMainDividerLocation() {
        if (this.lastLoggingDividerLocation >= 0) {
            return this.splitPaneV.getHeight() - this.lastLoggingDividerLocation;
        }
        return this.splitPaneV.getDividerLocation();
    }

    public int getLoggingDividerLocation() {
        if (this.lastMonitorDividerLocation >= 0) {
            return this.loggingSplitPaneH.getWidth() - this.lastMonitorDividerLocation;
        }
        return this.loggingSplitPaneH.getDividerLocation();
    }

    public void setDividerLocations(int mainH, int editorV, int loggingV, int groupSelectionV) {
        this.mainEditor.setDividerLocation(editorV);
        this.mainEditor.setGroupSelectionDivider(groupSelectionV);
        this.splitPaneV.setDividerLocation(mainH);
        this.loggingSplitPaneH.setDividerLocation(loggingV);
    }

    public void toggleLoggingViewer(boolean show) {
        if (show) {
            this.splitPaneV.add(this.loggingSplitPaneH);
            this.splitPaneV.setDividerLocation(this.splitPaneV.getHeight() - this.lastLoggingDividerLocation);
            this.lastLoggingDividerLocation = -1;
        } else {
            this.lastLoggingDividerLocation = this.splitPaneV.getHeight() - this.splitPaneV.getDividerLocation();
            this.splitPaneV.remove(this.loggingSplitPaneH);
        }
    }

    public void toggleSystemMonitor(boolean show) {
        if (show) {
            this.loggingSplitPaneH.add(this.systemMonitor);
            this.loggingSplitPaneH.setDividerLocation(this.loggingSplitPaneH.getWidth() - this.lastMonitorDividerLocation);
            this.lastMonitorDividerLocation = -1;
        } else {
            this.lastMonitorDividerLocation = this.loggingSplitPaneH.getWidth() - this.loggingSplitPaneH.getDividerLocation();
            this.loggingSplitPaneH.remove(this.systemMonitor);
        }
    }

    public void toggleExpertMode() {
        this.getPropertyTable().toggleExpertMode();
        this.updateToggleExpertModeIcon();
    }

    protected void updateToggleExpertModeIcon() {
        ((ToggleExpertModeAction)this.TOGGLE_EXPERT_MODE_ACTION_24).updateIcon();
        ((ToggleExpertModeAction)this.TOGGLE_EXPERT_MODE_ACTION_32).updateIcon();
    }

    public OperatorPropertyTable getPropertyTable() {
        return this.mainEditor.getPropertyTable();
    }

    public LoggingViewer getMessageViewer() {
        return this.messageViewer;
    }

    public OperatorTree getOperatorTree() {
        return this.mainEditor.getOperatorTree();
    }

    public MainExperimentEditor getMainExperimentEditor() {
        return this.mainEditor;
    }

    public ResultDisplay getResultDisplay() {
        return this.resultDisplay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setExperimentState(int state) {
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            this.experiment.setExperimentState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getExperimentState() {
        if (this.experiment == null) {
            return -1;
        }
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            return this.experiment.getExperimentState();
        }
    }

    public final synchronized Experiment getExperiment() {
        return this.experiment;
    }

    public void newExperiment() {
        if (this.close()) {
            this.stopExperiment();
            this.resultDisplay.clear();
            this.setExperiment(new Experiment());
            this.addToUndoList();
            this.changeMode(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runExperiment() {
        if (this.getExperimentState() == 0) {
            if ((this.isChanged() || this.getExperiment().getExperimentFile() == null) && !this.isTutorialMode() && JOptionPane.showConfirmDialog(this, "Save experiment file?", "Save?", 0) == 0) {
                this.save();
            }
            this.setExperimentState(2);
            this.enableActions();
            ExperimentThread experimentThread = this.experimentThread;
            synchronized (experimentThread) {
                Experiment experiment = this.experiment;
                synchronized (experiment) {
                    this.experiment.getRootOperator().clearListeners();
                    this.experimentThread = new ExperimentThread(this.experiment);
                    this.experiment.getRootOperator().addExperimentListener(this.statusBar);
                }
            }
            try {
                try {
                    LogService.initGUI();
                    this.resultDisplay.clear();
                    experimentThread = this.experimentThread;
                    synchronized (experimentThread) {
                        this.experimentThread.start();
                    }
                }
                catch (Throwable t) {
                    SwingTools.showSimpleErrorMessage("Cannot start experiment!", t);
                }
            }
            finally {
                this.getOperatorTree().refresh();
            }
        } else {
            ExperimentThread experimentThread = this.experimentThread;
            synchronized (experimentThread) {
                this.setExperimentState(2);
                this.enableActions();
                this.experimentThread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExperiment() {
        if (this.getExperimentState() != 0) {
            LogService.logMessage("Experiment stopped. Completing current operator...", 3);
            this.statusBar.setSpecialText("Experiment stopped. Completing current operator...");
            if (this.experimentThread != null) {
                ExperimentThread experimentThread = this.experimentThread;
                synchronized (experimentThread) {
                    if (this.experimentThread.isAlive()) {
                        this.experimentThread.setPriority(1);
                        this.experimentThread.stopExperiment();
                        this.experimentThread.notify();
                    }
                    this.setExperiment((Experiment)this.experiment.clone());
                    this.setExperimentState(0);
                    this.enableActions();
                    this.statusBar.experimentEnded();
                }
            }
        }
    }

    void experimentEnded(IOContainer results) {
        if (results != null) {
            this.resultDisplay.setData(results, "Experiment results:");
            this.changeMode(1);
            this.resultDisplay.showSomething();
            File file = this.experiment.getExperimentFile();
            String resultName = file != null ? file.getName() : "unnamed";
            YaleGUI.getResultHistory().addResults(resultName, this.experiment.getRootOperator(), results);
        }
        this.statusBar.experimentEnded();
        this.setExperimentState(0);
        this.enableActions();
    }

    public void breakpointReached(Operator operator, IOContainer ioContainer, int location) {
        this.resultDisplay.setData(ioContainer, "Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":");
        this.changeMode(1);
        this.resultDisplay.showSomething();
        ExperimentThread.beep("breakpoint");
        this.setExperimentState(1);
        this.enableActions();
    }

    public void resume() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setExperiment(Experiment experiment) {
        Object object;
        if (this.getExperimentState() != 0 && this.experimentThread != null) {
            object = this.experimentThread;
            synchronized (object) {
                this.experimentThread.stopExperiment();
            }
        }
        object = experiment;
        synchronized (object) {
            this.experiment = experiment;
            this.experiment.getRootOperator().clearListeners();
            this.experimentThread = new ExperimentThread(this.experiment);
            this.experiment.addBreakpointListener(this);
            this.experiment.addBreakpointListener(this.statusBar);
            this.experiment.getRootOperator().addExperimentListener(this.statusBar);
            this.setOperator(this.experiment.getRootOperator());
            this.enableActions();
        }
        this.setTitle();
    }

    private void setOperator(Operator root) {
        this.mainEditor.experimentChanged(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void experimentChanged() {
        boolean oldValue = this.changed;
        this.changed = true;
        this.addToUndoList();
        if (!oldValue) {
            this.setTitle();
        }
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            if (this.experiment.getExperimentFile() != null && !this.tutorialMode) {
                this.SAVE_ACTION_24.setEnabled(true);
                this.SAVE_ACTION_32.setEnabled(true);
            }
            this.mainEditor.getXMLEditor().experimentChanged(this.experiment.getRootOperator());
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void notifyEditorsOfChange(Operator currentlySelected) {
        this.mainEditor.setCurrentOperator(currentlySelected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToUndoList() {
        String lastStateXML = this.undoList.size() != 0 ? this.undoList.get(this.undoList.size() - 1) : null;
        String currentStateXML = null;
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            currentStateXML = this.experiment.getRootOperator().getXML("");
        }
        if (!(currentStateXML == null || lastStateXML != null && lastStateXML.equals(currentStateXML))) {
            if (this.undoIndex < this.undoList.size() - 1) {
                while (this.undoList.size() > this.undoIndex + 1) {
                    this.undoList.removeLast();
                }
            }
            this.undoList.add(currentStateXML);
            String maxSizeProperty = System.getProperty("yale.gui.undolist.size");
            int maxSize = 20;
            try {
                if (maxSizeProperty != null) {
                    maxSize = Integer.parseInt(maxSizeProperty);
                }
            }
            catch (NumberFormatException e) {
                LogService.logMessage("Bad integer format for property 'yale.gui.undolist.size', using default size of 20.", 4);
            }
            while (this.undoList.size() > maxSize) {
                this.undoList.removeFirst();
            }
            this.undoIndex = this.undoList.size() - 1;
            this.enableUndoAction();
        }
    }

    public void undo() {
        if (this.undoIndex > 0) {
            --this.undoIndex;
            this.setExperimentIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    public void redo() {
        if (this.undoIndex < this.undoList.size()) {
            ++this.undoIndex;
            this.setExperimentIntoStateAt(this.undoIndex);
        }
        this.enableUndoAction();
    }

    private void enableUndoAction() {
        if (this.undoIndex > 0) {
            this.UNDO_ACTION_24.setEnabled(true);
            this.UNDO_ACTION_32.setEnabled(true);
        } else {
            this.UNDO_ACTION_24.setEnabled(false);
            this.UNDO_ACTION_32.setEnabled(false);
        }
        if (this.undoIndex < this.undoList.size() - 1) {
            this.REDO_ACTION_24.setEnabled(true);
            this.REDO_ACTION_32.setEnabled(true);
        } else {
            this.REDO_ACTION_24.setEnabled(false);
            this.REDO_ACTION_32.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExperimentIntoStateAt(int undoIndex) {
        String stateXML = this.undoList.get(undoIndex);
        try {
            Experiment experiment = this.experiment;
            synchronized (experiment) {
                this.experiment.setupFromXML(stateXML);
                this.setExperiment(this.experiment);
                this.changed = true;
                this.setTitle();
                if (this.experiment.getExperimentFile() != null && !this.tutorialMode) {
                    this.SAVE_ACTION_24.setEnabled(true);
                    this.SAVE_ACTION_32.setEnabled(true);
                }
            }
        }
        catch (Exception e) {
            SwingTools.showErrorMessage("While changing experiment:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTitle() {
        if (this.hostname == null) {
            try {
                this.hostname = "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostname = "";
            }
        }
        File file = null;
        if (this.experiment != null) {
            Experiment experiment = this.experiment;
            synchronized (experiment) {
                file = this.experiment.getExperimentFile();
            }
        }
        if (file != null) {
            this.setTitle(TITLE + this.hostname + " (" + file.getName() + (this.changed ? "*" : "") + ")");
        } else {
            this.setTitle(TITLE + this.hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseName() {
        if (this.experiment != null) {
            File file = null;
            Experiment experiment = this.experiment;
            synchronized (experiment) {
                file = this.experiment.getExperimentFile();
            }
            if (file != null) {
                String base = file.getName();
                int dot = base.lastIndexOf(".");
                if (dot == -1) {
                    return base;
                }
                return base.substring(0, dot);
            }
            return "unnamed";
        }
        return "unnamed";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close() {
        if (this.changed) {
            File file = null;
            Experiment experiment = this.experiment;
            synchronized (experiment) {
                file = this.experiment.getExperimentFile();
            }
            if (file == null) {
                file = new File("unnamed.xml");
            }
            int choice = JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1);
            switch (choice) {
                case 0: {
                    this.save();
                    return true;
                }
                case 1: {
                    if (this.getExperimentState() != 0) {
                        ExperimentThread experimentThread = this.experimentThread;
                        synchronized (experimentThread) {
                            this.experimentThread.stopExperiment();
                        }
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void open() {
        if (this.close()) {
            File file = SwingTools.chooseFile((Component)this, null, true, "xml", "experiment file");
            if (file == null) {
                return;
            }
            this.open(file);
        }
    }

    public void open(File file) {
        this.open(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file, boolean showInfo) {
        this.stopExperiment();
        try {
            try {
                Experiment experiment = Yale.readExperimentFile(file);
                this.setExperiment(experiment);
                this.changeMode(0);
            }
            catch (XMLException ex) {
                SwingTools.showErrorMessage("While loading '" + file + "'", ex);
                Experiment experiment = new Experiment();
                experiment.setExperimentFile(file);
                this.setExperiment(experiment);
                this.changeMode(0);
                this.mainEditor.changeToXMLEditor();
                this.mainEditor.getXMLEditor().setText(Tools.readOutput(new BufferedReader(new FileReader(file))));
            }
        }
        catch (Exception ex) {
            SwingTools.showErrorMessage("While loading '" + file + "'", ex);
            return;
        }
        this.resultDisplay.clear();
        this.SAVE_ACTION_24.setEnabled(false);
        this.SAVE_ACTION_32.setEnabled(false);
        this.changed = false;
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            String text;
            YaleGUI.useExperimentFile(this.experiment);
            this.updateRecentFileList();
            this.addToUndoList();
            this.setTitle();
            if (showInfo && Tools.booleanValue(System.getProperty("yale.gui.experimentinfo.show"), true) && (text = this.experiment.getRootOperator().getUserDescription()) != null && text.length() != 0) {
                ExperimentInfoScreen infoScreen = new ExperimentInfoScreen((Frame)this, file.getName(), text);
                infoScreen.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            Experiment experiment = this.experiment;
            synchronized (experiment) {
                File file = this.experiment.getExperimentFile();
                if (file == null) {
                    file = SwingTools.chooseFile((Component)this, new File("."), false, "xml", "experiment file");
                    if (file == null) {
                        return;
                    }
                    this.experiment.setExperimentFile(file);
                }
                this.experiment.save();
                this.SAVE_ACTION_24.setEnabled(false);
                this.SAVE_ACTION_32.setEnabled(false);
                this.changed = false;
                this.setTitle();
                YaleGUI.useExperimentFile(this.experiment);
                this.updateRecentFileList();
                this.mainEditor.experimentChanged(this.experiment.getRootOperator());
            }
        }
        catch (IOException ex) {
            SwingTools.showErrorMessage("Cannot save experiment file!", ex);
        }
    }

    public void saveAs() {
        File file = SwingTools.chooseFile((Component)this, null, false, "xml", "experiment file");
        if (file != null) {
            this.getExperiment().setExperimentFile(file);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsTemplate() {
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            ExperimentOperator rootOperator = this.experiment.getRootOperator();
            SaveAsTemplateDialog dialog = new SaveAsTemplateDialog(this, rootOperator);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                Template template = dialog.getTemplate(rootOperator);
                String name = template.getName();
                try {
                    File templateFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".template");
                    template.save(templateFile);
                    File templateXmlFile = ParameterService.getUserConfigFile(String.valueOf(name) + ".xml");
                    this.experiment.save(templateXmlFile);
                }
                catch (IOException ioe) {
                    SwingTools.showSimpleErrorMessage("Cannot write template files:", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        block11: {
            block10: {
                if (!this.changed) break block10;
                File file = null;
                Experiment experiment = this.experiment;
                synchronized (experiment) {
                    file = this.experiment.getExperimentFile();
                }
                if (file == null) {
                    file = new File("unnamed.xml");
                }
                switch (JOptionPane.showConfirmDialog(this, "Save changes to '" + file + "'?", "Save changes", 1)) {
                    case 0: {
                        this.save();
                        if (this.changed) {
                            return;
                        }
                        break block11;
                    }
                    case 1: {
                        break block11;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (JOptionPane.showConfirmDialog(this, "Really exit?", "Exit Yale", 0) != 0) {
                return;
            }
        }
        this.stopExperiment();
        this.dispose();
        System.exit(0);
    }

    public void updateRecentFileList() {
        this.recentFilesMenu.removeAll();
        List<File> recentFiles = YaleGUI.getRecentFiles();
        Iterator<File> i = recentFiles.iterator();
        int j = 1;
        while (i.hasNext()) {
            final File recentFile = i.next();
            JMenuItem menuItem = new JMenuItem(String.valueOf(j) + " " + recentFile.getPath());
            menuItem.setMnemonic(48 + j);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.open(recentFile);
                }
            });
            this.recentFilesMenu.add(menuItem);
            ++j;
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableActions() {
        this.RUN_RESUME_ACTION_24.updateState();
        this.RUN_RESUME_ACTION_32.updateState();
        boolean[] currentStates = new boolean[10];
        Operator op = this.mainEditor.getOperatorTree().getSelectedOperator();
        if (op != null) {
            currentStates[0] = true;
            if (op instanceof OperatorChain) {
                currentStates[1] = true;
            }
            if (op.getParent() == null) {
                currentStates[2] = true;
            } else if (op.getParent().getNumberOfOperators() > 1) {
                currentStates[3] = true;
            }
        }
        Experiment experiment = this.experiment;
        synchronized (experiment) {
            currentStates[5] = this.getExperimentState() == 0;
            currentStates[6] = this.getExperimentState() == 1;
            currentStates[7] = this.getExperimentState() == 2 || this.getExperimentState() == 1;
        }
        currentStates[4] = this.mainEditor.getOperatorTree().getClipBoard() != null;
        currentStates[8] = this.mainEditor.isXMLViewActive();
        currentStates[9] = this.mainEditor.isDescriptionViewActive();
        ConditionalAction.updateAll(currentStates);
    }
}

