/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.gui;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.ExperimentListener;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.gui.tools.SwingTools;
import edu.udo.cs.yale.operator.ExperimentOperator;
import edu.udo.cs.yale.operator.ExperimentStoppedException;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.parameter.UndefinedParameterError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Toolkit;

public class ExperimentThread
extends Thread
implements ExperimentListener {
    private Experiment experiment;

    public ExperimentThread(Experiment experiment) {
        this.experiment = experiment;
        this.experiment.getRootOperator().addExperimentListener(this);
    }

    public void run() {
        try {
            IOContainer results = this.experiment.run();
            ExperimentThread.beep("success");
            this.experiment.getRootOperator().sendEmail(results, null);
            YaleGUI.getMainFrame().experimentEnded(results);
        }
        catch (ExperimentStoppedException ex) {
            ExperimentThread.beep("error");
            LogService.logMessage(ex.getMessage(), 8);
        }
        catch (Throwable e) {
            ExperimentThread.beep("error");
            LogService.logException(null, this.experiment, e);
            LogService.logMessageWithTree("Experiment failed!", 7, this.experiment, this.experiment.getCurrentOperator());
            try {
                this.experiment.getRootOperator().sendEmail(null, e);
            }
            catch (UndefinedParameterError ex) {
                LogService.logMessage("Problems during sending result mail: " + e.getMessage(), 4);
            }
            SwingTools.showErrorMessage("Experiment failed", e);
            YaleGUI.getMainFrame().experimentEnded(null);
        }
    }

    public static void beep(String reason) {
        if (Tools.booleanValue(System.getProperty("yale.gui.beep." + reason), false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void stopExperiment() {
        this.experiment.stop();
    }

    public void experimentStarts() {
        YaleGUI.getMainFrame().getResultDisplay().setDataTables(this.experiment.getDataTables());
    }

    public void experimentStep(ExperimentOperator op) {
    }

    public void experimentEnded() {
    }

    public String toString() {
        return "ExperimentThread (" + this.experiment.getExperimentFile() + ")";
    }
}

