/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.SingularNumericalGenerator;
import edu.udo.cs.yale.tools.LogService;

public class TrigonometricFunctionGenerator
extends SingularNumericalGenerator {
    public static final int SINUS = 0;
    public static final int COSINUS = 1;
    public static final int TANGENS = 2;
    public static final int ARC_TANGENS = 3;
    private static final String[] FUNCTION_NAMES = new String[]{"sin", "cos", "tan", "atan"};
    private int mode = 0;

    public TrigonometricFunctionGenerator(int mode) {
        this.mode = mode;
    }

    public TrigonometricFunctionGenerator() {
    }

    public FeatureGenerator newInstance() {
        return new TrigonometricFunctionGenerator(this.mode);
    }

    public double calculateValue(double value) {
        double r = 0.0;
        switch (this.mode) {
            case 0: {
                r = Math.sin(value);
                break;
            }
            case 1: {
                r = Math.cos(value);
                break;
            }
            case 2: {
                r = Math.tan(value);
                break;
            }
            case 3: {
                r = Math.atan(value);
            }
        }
        return r;
    }

    public void setFunction(String name) {
        int i = 0;
        while (i < FUNCTION_NAMES.length) {
            if (FUNCTION_NAMES[i].equals(name)) {
                this.mode = i;
                return;
            }
            ++i;
        }
        LogService.logMessage("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    public String getFunction() {
        return FUNCTION_NAMES[this.mode];
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.mode == ((TrigonometricFunctionGenerator)o).mode;
    }

    public int hashCode() {
        return super.hashCode() ^ Integer.valueOf(this.mode).hashCode();
    }
}

