/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ConstructionDescription;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingularNumericalGenerator
extends FeatureGenerator {
    private static final Attribute[] INPUT_ATTR = new Attribute[]{AttributeFactory.createAttribute(2)};

    public abstract double calculateValue(double var1);

    @Override
    public Attribute[] getInputAttributes() {
        return INPUT_ATTR;
    }

    @Override
    public Attribute[] getOutputAttributes(ExampleTable input) {
        Attribute a1 = this.getArgument(0);
        Attribute ao = AttributeFactory.createAttribute(2, 3, this.getFunction(), new ConstructionDescription[]{a1.getConstruction()});
        return new Attribute[]{ao};
    }

    @Override
    public List<Attribute[]> getInputCandidates(ExampleSet exampleSet, int maxDepth, String[] functions) {
        ArrayList<Attribute[]> result = new ArrayList<Attribute[]>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!this.checkCompatibility(attribute, INPUT_ATTR[0], maxDepth, functions)) continue;
            result.add(new Attribute[]{attribute});
        }
        return result;
    }

    @Override
    public void generate(DataRow data) throws GenerationException {
        try {
            Attribute a = this.getArgument(0);
            double value = data.get(a);
            double r = this.calculateValue(value);
            if (Double.isInfinite(r)) {
                LogService.logMessage(String.valueOf(this.getFunction()) + ": Infinite value generated, replaced by NaN.", 4);
                r = Double.NaN;
            }
            if (Double.isNaN(r)) {
                LogService.logMessage(String.valueOf(this.getFunction()) + ": NaN generated.", 4);
            }
            if (this.resultAttributes[0] != null) {
                data.set(this.resultAttributes[0], r);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new GenerationException("a:" + this.getArgument(0), ex);
        }
    }

    @Override
    public String toString() {
        String s = "singular function ";
        if (this.resultAttributes != null && this.resultAttributes.length > 0 && this.resultAttributes[0] != null) {
            s = String.valueOf(s) + this.resultAttributes[0].getName() + ":=";
        }
        s = String.valueOf(s) + this.getFunction() + "(";
        if (this.argumentsSet()) {
            s = String.valueOf(s) + this.getArgument(0).getName();
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

