/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.SingularNumericalGenerator;
import edu.udo.cs.yale.tools.LogService;

public class ReciprocalValueGenerator
extends SingularNumericalGenerator {
    public static final String[] FUNCTION_NAMES = new String[]{"1/"};

    public FeatureGenerator newInstance() {
        return new ReciprocalValueGenerator();
    }

    public double calculateValue(double value) {
        return 1.0 / value;
    }

    public void setFunction(String name) {
        int i = 0;
        while (i < FUNCTION_NAMES.length) {
            if (FUNCTION_NAMES[i].equals(name)) {
                return;
            }
            ++i;
        }
        LogService.logMessage("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    public String getFunction() {
        return FUNCTION_NAMES[0];
    }
}

