/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.generator;

import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.SingularNumericalGenerator;
import edu.udo.cs.yale.tools.LogService;

public class FloorCeilGenerator
extends SingularNumericalGenerator {
    public static final int FLOOR = 0;
    public static final int CEIL = 1;
    public static final int ROUND = 2;
    private static final String[] FUNCTION_NAMES = new String[]{"floor", "ceil", "round"};
    private int mode;

    public FloorCeilGenerator(int mode) {
        this.mode = mode;
    }

    public FloorCeilGenerator() {
    }

    public FeatureGenerator newInstance() {
        return new FloorCeilGenerator(this.mode);
    }

    public double calculateValue(double value) {
        double r = 0.0;
        switch (this.mode) {
            case 0: {
                r = Math.floor(value);
                break;
            }
            case 1: {
                r = Math.ceil(value);
                break;
            }
            case 2: {
                r = Math.round(value);
            }
        }
        return r;
    }

    public void setFunction(String name) {
        int i = 0;
        while (i < FUNCTION_NAMES.length) {
            if (FUNCTION_NAMES[i].equals(name)) {
                this.mode = i;
                return;
            }
            ++i;
        }
        LogService.logMessage("Illegal function name '" + name + "' for " + this.getClass().getName() + ".", 6);
    }

    public String getFunction() {
        return FUNCTION_NAMES[this.mode];
    }

    public boolean equals(Object o) {
        return super.equals(o) && this.mode == ((FloorCeilGenerator)o).mode;
    }

    public int hashCode() {
        return super.hashCode() ^ Integer.valueOf(this.mode).hashCode();
    }
}

