/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example.test;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.example.test.ExampleTestTools;
import edu.udo.cs.yale.test.TestCase;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;

public class SparseReaderTest
extends TestCase {
    private static final String[] ATTRIBUTE_STRINGS = new String[]{"5:3.0 2:8.0", "1:cat 3:2.5 4:1.5e-1", "5:1.0", "1:dog 4:7.3e1"};
    private static final String[] LABEL = new String[]{"yes", "no", "no", "yes"};

    public void readerTest(int format, Reader input, Reader labelInput) throws Exception {
        AttributeSet attributeSet = new AttributeSet();
        Attribute att1 = ExampleTestTools.attributeDogCatMouse();
        Attribute att2 = ExampleTestTools.attributeReal(1);
        Attribute att3 = ExampleTestTools.attributeReal(2);
        Attribute att4 = ExampleTestTools.attributeReal(3);
        Attribute att5 = ExampleTestTools.attributeReal(4);
        Attribute att6 = ExampleTestTools.attributeYesNo();
        attributeSet.addAttribute(att1);
        attributeSet.addAttribute(att2);
        attributeSet.addAttribute(att3);
        attributeSet.addAttribute(att4);
        attributeSet.addAttribute(att5);
        attributeSet.setSpecialAttribute("label", att6);
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("l", "label");
        SparseFormatDataRowReader reader = new SparseFormatDataRowReader(new DataRowFactory(10, '.'), format, prefixMap, attributeSet, input, labelInput, -1);
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        table.readExamples(reader);
        ExampleSet exampleSet = table.createExampleSet(attributeSet);
        Iterator r = exampleSet.iterator();
        Example e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 1, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 1, column 2", (double)8.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 4", (double)0.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, column 5", (double)3.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 1, label", (String)"yes", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 2, column 1", (String)"cat", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 2, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 3", (double)2.5, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 4", (double)0.15, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, column 5", (double)0.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 2, label", (String)"no", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 3, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 3, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 4", (double)0.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, column 5", (double)1.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 3, label", (String)"no", (String)e.getValueAsString(att6));
        e = (Example)r.next();
        SparseReaderTest.assertEquals((String)"example 4, column 1", (String)"dog", (String)e.getValueAsString(att1));
        SparseReaderTest.assertEquals((String)"example 4, column 2", (double)0.0, (double)e.getValue(att2), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 3", (double)0.0, (double)e.getValue(att3), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 4", (double)73.0, (double)e.getValue(att4), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, column 5", (double)0.0, (double)e.getValue(att5), (double)1.0E-8);
        SparseReaderTest.assertEquals((String)"example 4, label", (String)"yes", (String)e.getValueAsString(att6));
    }

    public void testFormatXY() throws Exception {
        String input = "# comment" + Tools.getLineSeparator();
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input = String.valueOf(input) + ATTRIBUTE_STRINGS[i] + " " + LABEL[i] + Tools.getLineSeparator();
            ++i;
        }
        this.readerTest(0, new StringReader(input), null);
    }

    public void testFormatYX() throws Exception {
        String input = "# comment" + Tools.getLineSeparator();
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input = String.valueOf(input) + LABEL[i] + " " + ATTRIBUTE_STRINGS[i] + Tools.getLineSeparator();
            ++i;
        }
        this.readerTest(1, new StringReader(input), null);
    }

    public void testFormatPrefix() throws Exception {
        String input = "# comment" + Tools.getLineSeparator();
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            input = String.valueOf(input) + "l:" + LABEL[i] + " " + ATTRIBUTE_STRINGS[i] + Tools.getLineSeparator();
            ++i;
        }
        this.readerTest(2, new StringReader(input), null);
    }

    public void testFormatSeparate() throws Exception {
        String input = "# comment" + Tools.getLineSeparator();
        String label = "";
        int i = 0;
        while (i < ATTRIBUTE_STRINGS.length) {
            label = String.valueOf(label) + LABEL[i] + Tools.getLineSeparator();
            input = String.valueOf(input) + ATTRIBUTE_STRINGS[i] + Tools.getLineSeparator();
            ++i;
        }
        this.readerTest(3, new StringReader(input), new StringReader(label));
    }
}

