/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example.test;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class ExampleTestTools {
    public static DataRowReader createDataRowReader(DataRowFactory factory, Attribute[] attributes, String[][] values) {
        LinkedList<DataRow> dataRows = new LinkedList<DataRow>();
        int i = 0;
        while (i < values.length) {
            dataRows.add(factory.create(values[i], attributes));
            ++i;
        }
        return new ListDataRowReader(dataRows.iterator());
    }

    public static DataRowReader createDataRowReader(double[][] values) {
        LinkedList<DoubleArrayDataRow> dataRows = new LinkedList<DoubleArrayDataRow>();
        int i = 0;
        while (i < values.length) {
            dataRows.add(new DoubleArrayDataRow(values[i]));
            ++i;
        }
        return new ListDataRowReader(dataRows.iterator());
    }

    public static DataRowReader createDataRowReader(int size, Attribute[] attributes) {
        Random random = new Random(0L);
        LinkedList<DoubleArrayDataRow> dataRows = new LinkedList<DoubleArrayDataRow>();
        int i = 0;
        while (i < size) {
            double[] data = new double[attributes.length];
            int j = 0;
            while (j < data.length) {
                if (attributes[j].isNominal()) {
                    data[j] = random.nextInt(attributes[j].getMapping().getValues().size());
                }
                data[j] = attributes[j].getValueType() == 3 ? (double)(random.nextInt(200) - 100) : 20.0 * random.nextDouble() - 10.0;
                ++j;
            }
            dataRows.add(new DoubleArrayDataRow(data));
            ++i;
        }
        return new ListDataRowReader(dataRows.iterator());
    }

    public static MemoryExampleTable createMemoryExampleTable(int size) {
        Attribute[] attributes = ExampleTestTools.createFourAttributes();
        return new MemoryExampleTable(Arrays.asList(attributes), ExampleTestTools.createDataRowReader(size, attributes));
    }

    public static Attribute attributeDogCatMouse() {
        Attribute a = AttributeFactory.createAttribute("animal", 1);
        a.getMapping().mapString("dog");
        a.getMapping().mapString("cat");
        a.getMapping().mapString("mouse");
        return a;
    }

    public static Attribute attributeYesNo() {
        Attribute a = AttributeFactory.createAttribute("decision", 1);
        a.getMapping().mapString("no");
        a.getMapping().mapString("yes");
        return a;
    }

    public static Attribute attributeInt() {
        Attribute a = AttributeFactory.createAttribute("integer", 3);
        return a;
    }

    public static Attribute attributeReal() {
        Attribute a = AttributeFactory.createAttribute("real", 4);
        return a;
    }

    public static Attribute attributeReal(int index) {
        Attribute a = AttributeFactory.createAttribute("real" + index, 4);
        return a;
    }

    public static Attribute[] createFourAttributes() {
        Attribute[] attributes = new Attribute[]{ExampleTestTools.attributeDogCatMouse(), ExampleTestTools.attributeYesNo(), ExampleTestTools.attributeInt(), ExampleTestTools.attributeReal()};
        int i = 0;
        while (i < attributes.length) {
            attributes[i].setTableIndex(i);
            ++i;
        }
        return attributes;
    }

    public static Attribute createPredictedLabel(ExampleSet exampleSet) {
        Attribute predictedLabel = AttributeFactory.createAttribute(exampleSet.getAttributes().getLabel(), "prediction");
        exampleSet.getExampleTable().addAttribute(predictedLabel);
        exampleSet.getAttributes().setPredictedLabel(predictedLabel);
        return predictedLabel;
    }
}

