/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example.test;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.test.ExampleTestTools;
import edu.udo.cs.yale.test.TestCase;

public class DataRowTest
extends TestCase {
    private Attribute[] attributes;
    private double[] expected;

    public void setUp() throws Exception {
        super.setUp();
        this.attributes = ExampleTestTools.createFourAttributes();
        this.expected = new double[]{1.0, Double.NaN, 5.0, 2.3};
    }

    public void tearDown() throws Exception {
        this.attributes = null;
        this.expected = null;
        super.tearDown();
    }

    private void assertDataRow(String message, DataRow dataRow, double[] expected) {
        int i = 0;
        while (i < expected.length) {
            this.assertEqualsNaN(String.valueOf(message) + " " + this.attributes[i].getName(), expected[i], dataRow.get(this.attributes[i]));
            ++i;
        }
    }

    private void objectTest(String message, DataRowFactory factory) {
        Object[] objectArray = new Object[4];
        objectArray[0] = "cat";
        objectArray[2] = 5;
        objectArray[3] = new Double(2.3);
        DataRow dataRow = factory.create(objectArray, this.attributes);
        this.assertDataRow(String.valueOf(message) + " object", dataRow, this.expected);
    }

    private void stringTest(String message, DataRowFactory factory) {
        DataRow dataRow = factory.create(new String[]{"cat", "?", "5", "2.3"}, this.attributes);
        this.assertDataRow(String.valueOf(message) + " string", dataRow, this.expected);
    }

    public void testDoubleArrayStrings() {
        this.objectTest("double_array", new DataRowFactory(0, '.'));
    }

    public void testDoubleArrayObjects() {
        this.stringTest("double_array", new DataRowFactory(0, '.'));
    }

    public void testSparseMapStrings() {
        this.stringTest("sparse_map", new DataRowFactory(10, '.'));
    }

    public void testSparseMapObjects() {
        this.objectTest("sparse_map", new DataRowFactory(10, '.'));
    }
}

