/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class YaleLineReader {
    private Pattern separatorPattern;
    private String[] commentChars;
    private boolean useQuotes = false;
    private int lineNumber = 1;

    public YaleLineReader(String separatorsRegExpr, char[] commentChars, boolean useQuotes) {
        this.separatorPattern = Pattern.compile(separatorsRegExpr);
        this.commentChars = new String[commentChars.length];
        int i = 0;
        while (i < commentChars.length) {
            this.commentChars[i] = Character.toString(commentChars[i]);
            ++i;
        }
        this.useQuotes = useQuotes;
    }

    public String[] readLine(BufferedReader in, int expectedNumberOfColumns) throws IOException {
        String line = null;
        while (line == null) {
            line = in.readLine();
            if (line == null) break;
            line = line.trim();
            int c = 0;
            while (c < this.commentChars.length) {
                if (line.indexOf(this.commentChars[c]) >= 0) {
                    line = line.substring(0, line.indexOf(this.commentChars[c]));
                }
                ++c;
            }
            if (line.trim().length() != 0) continue;
            line = null;
        }
        if (line == null) {
            return null;
        }
        String[] columns = this.separatorPattern.split(line);
        if (this.useQuotes) {
            columns = Tools.mergeQuotedSplits(line, columns, "\"");
        }
        if (expectedNumberOfColumns != -1) {
            if (columns.length < expectedNumberOfColumns) {
                throw new IOException("Data format error in line " + this.lineNumber + ": the line does not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")! Stop reading...");
            }
            if (columns.length > expectedNumberOfColumns) {
                LogService.logMessage("Possible data format error: a line did not provide the expected number of columns (was: " + columns.length + ", expected: " + expectedNumberOfColumns + ")!", 4);
            }
        }
        ++this.lineNumber;
        return columns;
    }
}

