/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.WeightedAttribute;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedAttributeRoleIterator
implements Iterator<AttributeRole> {
    private Iterator<AttributeRole> parent;
    private AttributeRole current = null;
    private boolean hasNextInvoked = false;
    private AttributeWeights weights;
    private boolean ignoreAttributesWithZeroWeight = false;

    public WeightedAttributeRoleIterator(Iterator<AttributeRole> parent, AttributeWeights weights, boolean ignoreZeroWeights) {
        this.parent = parent;
        this.weights = weights;
        this.ignoreAttributesWithZeroWeight = ignoreZeroWeights;
    }

    @Override
    public boolean hasNext() {
        this.hasNextInvoked = true;
        if (!this.parent.hasNext()) {
            this.current = null;
            return false;
        }
        AttributeRole role = this.parent.next();
        double weight = this.weights.getWeight(role.getAttribute().getName());
        if (this.ignoreAttributesWithZeroWeight && !Double.isNaN(weight) && Tools.isEqual(weight, 0.0)) {
            return this.hasNext();
        }
        this.current = new AttributeRole(new WeightedAttribute(role.getAttribute(), weight));
        this.current.setSpecial(role.getSpecialName());
        return true;
    }

    @Override
    public AttributeRole next() {
        if (!this.hasNextInvoked) {
            this.hasNext();
        }
        this.hasNextInvoked = false;
        return this.current;
    }

    @Override
    public void remove() {
        this.parent.remove();
    }
}

