/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.NominalMapping;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class Tools {
    public static void fillTableWithRandomValues(ExampleTable exampleTable, RandomGenerator random) {
        DataRowReader reader = exampleTable.getDataRowReader();
        Attribute[] attributes = exampleTable.getAttributes();
        while (reader.hasNext()) {
            DataRow dataRow = (DataRow)reader.next();
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i] != null) {
                    if (!attributes[i].isNominal()) {
                        NumericalAttributeStatistics stats = (NumericalAttributeStatistics)attributes[i].getStatistics();
                        double min = stats.getMinimum();
                        double max = stats.getMaximum();
                        if (max > min) {
                            dataRow.set(attributes[i], random.nextDoubleInRange(min, max));
                        } else {
                            dataRow.set(attributes[i], random.nextDouble());
                        }
                    } else {
                        dataRow.set(attributes[i], 0.0);
                    }
                }
                ++i;
            }
        }
    }

    public static Attribute[] createRegularAttributeArray(ExampleSet exampleSet) {
        Attribute[] attributes = new Attribute[exampleSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            attributes[counter++] = attribute;
        }
        return attributes;
    }

    public static Attribute[] getRandomCompatibleAttributes(ExampleSet exampleSet, FeatureGenerator generator, int maxDepth, String[] functions, Random random) {
        List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, maxDepth, functions);
        if (inputAttributes.size() > 0) {
            return inputAttributes.get(random.nextInt(inputAttributes.size()));
        }
        return null;
    }

    public static Attribute[] getWeightedCompatibleAttributes(AttributeWeightedExampleSet exampleSet, FeatureGenerator generator, int maxDepth, String[] functions, RandomGenerator random) {
        List<Attribute[]> inputAttributes = generator.getInputCandidates(exampleSet, maxDepth, functions);
        double[] probs = new double[inputAttributes.size()];
        double probSum = 0.0;
        Iterator<Attribute[]> i = inputAttributes.iterator();
        int k = 0;
        while (i.hasNext()) {
            Attribute[] candidate = i.next();
            int j = 0;
            while (j < candidate.length) {
                double weight = exampleSet.getWeight(candidate[j]);
                probSum += weight;
                probs[k] = weight;
                ++j;
            }
        }
        int j = 0;
        while (j < probs.length) {
            int n = j++;
            probs[n] = probs[n] / probSum;
        }
        return inputAttributes.get(random.randomIndex(probs));
    }

    public static Attribute createSpecialAttribute(ExampleSet exampleSet, String name, int valueType) {
        Attribute attribute = AttributeFactory.createAttribute(AttributeFactory.createName(name), valueType);
        exampleSet.getExampleTable().addAttribute(attribute);
        exampleSet.getAttributes().setSpecialAttribute(attribute, name);
        return attribute;
    }

    public static Attribute createWeightAttribute(ExampleSet exampleSet) {
        Attribute weight = exampleSet.getAttributes().getWeight();
        if (weight != null) {
            LogService.logMessage("ExampleSet.createWeightAttribute(): Overwriting old weight attribute!", 4);
        }
        weight = AttributeFactory.createAttribute("weight", 4);
        exampleSet.getExampleTable().addAttribute(weight);
        exampleSet.getAttributes().setWeight(weight);
        DataRowReader reader = exampleSet.getExampleTable().getDataRowReader();
        while (reader.hasNext()) {
            DataRow data = (DataRow)reader.next();
            data.set(weight, 1.0);
        }
        return weight;
    }

    public static boolean containsValueType(ExampleSet exampleSet, int valueType) {
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), valueType)) continue;
            return true;
        }
        return false;
    }

    public static void replaceValue(Attribute attribute, String oldValue, String newValue) {
        if (!attribute.isNominal()) {
            throw new RuntimeException("Example-Tools: replaceValue is only supported for nominal attributes.");
        }
        NominalMapping mapping = attribute.getMapping();
        int oldIndex = mapping.getIndex(oldValue);
        if (oldIndex < 0) {
            throw new RuntimeException("Example-Tools: replaceValue cannot be performed since old value was not defined in the attribute.");
        }
        mapping.setMapping(newValue, oldIndex);
    }

    public static void replaceValue(ExampleSet exampleSet, Attribute attribute, double oldValue, double newValue) {
        for (Example example : exampleSet) {
            double value = example.getValue(attribute);
            if (!edu.udo.cs.yale.tools.Tools.isEqual(value, oldValue)) continue;
            example.setValue(attribute, newValue);
        }
    }

    public static boolean compatible(Attribute first, Attribute second) {
        return Ontology.ATTRIBUTE_VALUE_TYPE.isA(first.getValueType(), second.getValueType()) && Ontology.ATTRIBUTE_BLOCK_TYPE.isA(first.getBlockType(), second.getBlockType());
    }

    public static double getAverageWeight(AttributeWeightedExampleSet exampleSet) {
        int counter = 0;
        double weightSum = 0.0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double weight = exampleSet.getWeight(attribute);
            if (Double.isNaN(weight)) continue;
            weightSum += Math.abs(weight);
            ++counter;
        }
        return weightSum / (double)counter;
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, false);
    }

    public static double[] getInverseProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet) {
        return Tools.getProbabilitiesFromWeights(attributes, exampleSet, true);
    }

    public static double[] getProbabilitiesFromWeights(Attribute[] attributes, AttributeWeightedExampleSet exampleSet, boolean inverse) {
        double weightSum = 0.0;
        int counter = 0;
        int i = 0;
        while (i < attributes.length) {
            double weight = exampleSet.getWeight(attributes[i]);
            if (!Double.isNaN(weight)) {
                weightSum += Math.abs(weight);
                ++counter;
            }
            ++i;
        }
        double weightAverage = weightSum / (double)counter;
        weightSum += (double)(attributes.length - counter) * weightAverage;
        double[] probs = new double[attributes.length];
        int i2 = 0;
        while (i2 < probs.length) {
            double weight = exampleSet.getWeight(attributes[i2]);
            probs[i2] = Double.isNaN(weight) ? weightAverage / weightSum : (inverse ? (2.0 * weightAverage - Math.abs(weight)) / weightSum : Math.abs(weight) / weightSum);
            ++i2;
        }
        return probs;
    }

    public static Attribute selectAttribute(Attribute[] attributes, double[] probs, Random random) {
        double r = random.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < attributes.length) {
            if (r < (sum += probs[i])) {
                return attributes[i];
            }
            ++i;
        }
        return attributes[attributes.length - 1];
    }

    public static boolean isDefault(double defaultValue, double value) {
        if (Double.isNaN(defaultValue)) {
            return Double.isNaN(value);
        }
        return defaultValue == value;
    }
}

