/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.Partition;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittedExampleSetReader
extends AbstractExampleReader {
    private Iterator<Example> reader;
    private int current;
    private Partition partition;
    private Example next;

    public SplittedExampleSetReader(Iterator<Example> reader, Partition partition) {
        this.reader = reader;
        this.partition = partition;
        this.current = -1;
        this.hasNext();
    }

    @Override
    public boolean hasNext() {
        while (this.next == null) {
            ++this.current;
            Example example = this.reader.next();
            if (example == null) {
                return false;
            }
            if (this.current >= this.partition.getTotalSize()) {
                return false;
            }
            if (!this.partition.isSelected(this.current)) continue;
            this.next = example;
        }
        return true;
    }

    @Override
    public Example next() {
        if (!this.hasNext()) {
            return null;
        }
        Example dummy = this.next;
        this.next = null;
        return dummy;
    }
}

