/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.Partition;
import edu.udo.cs.yale.example.PartitionBuilder;
import edu.udo.cs.yale.example.ShuffledPartitionBuilder;
import edu.udo.cs.yale.example.SimplePartitionBuilder;
import edu.udo.cs.yale.example.SplittedExampleSetReader;
import edu.udo.cs.yale.example.StratifiedPartitionBuilder;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplittedExampleSet
extends AbstractExampleSet {
    public static final String[] SAMPLING_NAMES = new String[]{"linear sampling", "shuffled sampling", "stratified sampling"};
    public static final int LINEAR_SAMPLING = 0;
    public static final int SHUFFLED_SAMPLING = 1;
    public static final int STRATIFIED_SAMPLING = 2;
    private Partition partition;
    private ExampleSet parent;

    public SplittedExampleSet(ExampleSet exampleSet, Partition partition) {
        this.parent = exampleSet;
        this.partition = partition;
    }

    public SplittedExampleSet(ExampleSet exampleSet, double splitRatio, int samplingType, int seed) {
        this(exampleSet, new double[]{splitRatio, 1.0 - splitRatio}, samplingType, seed);
    }

    public SplittedExampleSet(ExampleSet exampleSet, double[] splitRatios, int samplingType, int seed) {
        this(exampleSet, new Partition(splitRatios, exampleSet.size(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType, seed)));
    }

    public SplittedExampleSet(ExampleSet exampleSet, int numberOfSubsets, int samplingType, int seed) {
        this(exampleSet, new Partition(numberOfSubsets, exampleSet.size(), SplittedExampleSet.createPartitionBuilder(exampleSet, samplingType, seed)));
    }

    public SplittedExampleSet(SplittedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.partition = (Partition)exampleSet.partition.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SplittedExampleSet)) {
            return false;
        }
        return this.partition.equals(((SplittedExampleSet)o).partition);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.partition.hashCode();
    }

    private static PartitionBuilder createPartitionBuilder(ExampleSet exampleSet, int samplingType, int seed) {
        PartitionBuilder builder = null;
        switch (samplingType) {
            case 0: {
                builder = new SimplePartitionBuilder();
                break;
            }
            case 1: {
                builder = new ShuffledPartitionBuilder(seed);
                break;
            }
            default: {
                Attribute label = exampleSet.getAttributes().getLabel();
                if (label != null && label.isNominal()) {
                    builder = new StratifiedPartitionBuilder(exampleSet, seed);
                    break;
                }
                LogService.logMessage("Example set has no nominal label: using shuffled partition instead of stratified partition!", 4);
                builder = new ShuffledPartitionBuilder(seed);
            }
        }
        return builder;
    }

    public void selectAdditionalSubset(int index) {
        this.partition.selectSubset(index);
    }

    public void selectSingleSubset(int index) {
        this.partition.clearSelection();
        this.partition.selectSubset(index);
    }

    public void selectAllSubsetsBut(int index) {
        this.partition.clearSelection();
        int i = 0;
        while (i < this.partition.getNumberOfSubsets()) {
            if (i != index) {
                this.partition.selectSubset(i);
            }
            ++i;
        }
    }

    public void invertSelection() {
        this.partition.invertSelection();
    }

    public void clearSelection() {
        this.partition.clearSelection();
    }

    public int getNumberOfSubsets() {
        return this.partition.getNumberOfSubsets();
    }

    @Override
    public Iterator<Example> iterator() {
        return new SplittedExampleSetReader(this.parent.iterator(), (Partition)this.partition.clone());
    }

    @Override
    public int size() {
        return this.partition.getSelectionSize();
    }

    @Override
    public Example getExample(int index) {
        int actualIndex = this.partition.mapIndex(index);
        return this.parent.getExample(actualIndex);
    }

    public int getActualParentIndex(int index) {
        return this.partition.mapIndex(index);
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    public static SplittedExampleSet splitByAttribute(ExampleSet exampleSet, Attribute attribute) {
        int[] elements = new int[exampleSet.size()];
        Iterator reader = exampleSet.iterator();
        int i = 0;
        int maxNumber = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            int value = (int)example.getValue(attribute);
            maxNumber = Math.max(maxNumber, value);
            elements[i++] = value;
        }
        Partition partition = new Partition(elements, maxNumber + 1);
        return new SplittedExampleSet(exampleSet, partition);
    }
}

