/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractDataRowReader;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFormatDataRowReader
extends AbstractDataRowReader {
    public static final String[] FORMAT_NAMES = new String[]{"xy", "yx", "prefix", "separate_file", "no_label"};
    public static final int FORMAT_XY = 0;
    public static final int FORMAT_YX = 1;
    public static final int FORMAT_PREFIX = 2;
    public static final int FORMAT_SEPARATE_FILE = 3;
    public static final int FORMAT_NO_LABEL = 4;
    private BufferedReader inAttributes;
    private BufferedReader inLabels;
    private AttributeSet attributeSet = null;
    private boolean eof;
    private boolean lineRead;
    private int maxNumber;
    private int linesRead;
    private DataRow currentDataRow;
    private int format;
    private int dimension;
    private Map<String, String> prefixMap = new HashMap<String, String>();

    public SparseFormatDataRowReader(DataRowFactory factory, int format, Map<String, String> prefixMap, AttributeSet attributeSet, Reader attributeReader, Reader labelReader, int sampleSize) {
        super(factory);
        this.format = format;
        this.prefixMap = prefixMap;
        this.attributeSet = attributeSet;
        if (attributeSet == null) {
            throw new IllegalArgumentException("AttributeSet must not be null.");
        }
        this.dimension = attributeSet.getAllAttributes().size();
        this.maxNumber = sampleSize;
        this.inAttributes = new BufferedReader(attributeReader);
        if (format == 3) {
            if (labelReader == null) {
                throw new IllegalArgumentException("labelReader must not be null if format is 'separate_file'!");
            }
            this.inLabels = new BufferedReader(labelReader);
        }
        if (format != 4 && attributeSet.getSpecialAttribute("label") == null) {
            throw new IllegalArgumentException("If format is not no_label, label attribute must be defined.");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.maxNumber > -1 && this.linesRead >= this.maxNumber) {
            return false;
        }
        if (this.lineRead) {
            return !this.eof;
        }
        try {
            boolean bl = this.eof = !this.readLine();
            if (this.eof) {
                this.inAttributes.close();
                if (this.inLabels != null) {
                    this.inLabels.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.lineRead = true;
        return !this.eof;
    }

    private boolean readLine() throws IOException {
        String attributeLine = null;
        do {
            if ((attributeLine = this.inAttributes.readLine()) != null) continue;
            return false;
        } while (attributeLine.startsWith("#") || attributeLine.length() == 0);
        this.currentDataRow = this.getFactory().create(this.dimension);
        StringTokenizer tokenizer = new StringTokenizer(attributeLine);
        String labelString = null;
        if (this.format == 1) {
            labelString = tokenizer.nextToken();
        } else if (this.format == 3) {
            do {
                if ((labelString = this.inLabels.readLine()) != null) continue;
                return false;
            } while (labelString.startsWith("#") || labelString.length() == 0);
        }
        while (tokenizer.hasMoreTokens()) {
            Attribute attribute;
            String value;
            block22: {
                String attributeToken = tokenizer.nextToken();
                int colonIndex = attributeToken.indexOf(58);
                if (this.format == 0 && colonIndex == -1) {
                    if (labelString != null) {
                        throw new IOException("Malformed line in examplefile: " + attributeToken);
                    }
                    labelString = attributeToken;
                    continue;
                }
                String pos = attributeToken.substring(0, colonIndex);
                value = attributeToken.substring(colonIndex + 1);
                attribute = null;
                try {
                    int index = Integer.parseInt(pos) - 1;
                    if (index < 0 || index >= this.attributeSet.getNumberOfRegularAttributes()) {
                        throw new IOException("Attribute index out of range: '" + (index + 1) + "'! Index must be between 1 and dimension " + this.attributeSet.getNumberOfRegularAttributes() + "!");
                    }
                    attribute = this.attributeSet.getAttribute(index);
                }
                catch (NumberFormatException e) {
                    String specialAttributeName = this.prefixMap.get(pos);
                    if (specialAttributeName == null) {
                        attribute = this.attributeSet.getSpecialAttribute(pos);
                        if (attribute == null) {
                            throw new IOException("Illegal attribute index: '" + pos + "' (legal values are integers and defined prefixes for special attributes (Parameter prefix_map of SparseFormatExampleSource))!");
                        }
                    } else {
                        attribute = this.attributeSet.getSpecialAttribute(specialAttributeName);
                    }
                    if (attribute != null) break block22;
                    throw new IOException("Unknown special attribute: " + specialAttributeName);
                }
            }
            if (attribute == null) continue;
            if (attribute.isNominal()) {
                this.currentDataRow.set(attribute, attribute.getMapping().mapString(value));
                continue;
            }
            try {
                this.currentDataRow.set(attribute, Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw new IOException("Attribute is not numerical: '" + value + "'!");
            }
        }
        if (labelString != null) {
            Attribute label = this.attributeSet.getSpecialAttribute("label");
            if (label.isNominal()) {
                this.currentDataRow.set(label, label.getMapping().mapString(labelString));
            } else {
                try {
                    this.currentDataRow.set(label, Double.parseDouble(labelString));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Label is not numerical: '" + labelString + "'.");
                }
            }
        }
        return true;
    }

    @Override
    public DataRow next() {
        if (this.eof) {
            return null;
        }
        if (!this.lineRead && !this.hasNext()) {
            return null;
        }
        ++this.linesRead;
        this.lineRead = false;
        return this.currentDataRow;
    }
}

