/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.SortedExampleReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedExampleSet
extends AbstractExampleSet {
    public static final String[] SORTING_DIRECTIONS = new String[]{"increasing", "decreasing"};
    public static final int INCREASING = 0;
    public static final int DECREASING = 1;
    private ExampleSet parent;
    private int[] mapping;

    public SortedExampleSet(ExampleSet parent, Attribute sortingAttribute, int sortingDirection) {
        this.parent = parent;
        ArrayList<SortingIndex> sortingIndex = new ArrayList<SortingIndex>(parent.size());
        int counter = 0;
        for (Example example : parent) {
            double value = example.getValue(sortingAttribute);
            if (sortingAttribute.isNominal()) {
                sortingIndex.add(new SortingIndex(sortingAttribute.getMapping().mapIndex((int)value), counter));
            } else {
                sortingIndex.add(new SortingIndex(value, counter));
            }
            ++counter;
        }
        Collections.sort(sortingIndex);
        int[] mapping = new int[parent.size()];
        counter = 0;
        Iterator k = sortingIndex.iterator();
        while (k.hasNext()) {
            int index = ((SortingIndex)k.next()).getIndex();
            if (sortingDirection == 0) {
                mapping[counter] = index;
            } else {
                mapping[parent.size() - 1 - counter] = index;
            }
            ++counter;
        }
        this.mapping = mapping;
    }

    public SortedExampleSet(ExampleSet parent, int[] mapping) {
        this.parent = parent;
        this.mapping = mapping;
    }

    public SortedExampleSet(SortedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.mapping = exampleSet.mapping;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof SortedExampleSet)) {
            return false;
        }
        SortedExampleSet other = (SortedExampleSet)o;
        if (this.mapping.length != other.mapping.length) {
            return false;
        }
        int i = 0;
        while (i < this.mapping.length) {
            if (this.mapping[i] != other.mapping[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.mapping.hashCode();
    }

    @Override
    public Iterator<Example> iterator() {
        return new SortedExampleReader(this.parent, this.mapping);
    }

    @Override
    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the mapped ExampleSet!");
        }
        return this.parent.getExample(this.mapping[index]);
    }

    @Override
    public int size() {
        return this.mapping.length;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortingIndex
    implements Comparable<SortingIndex> {
        private Object key;
        private int index;

        public SortingIndex(Object key, int index) {
            this.key = key;
            this.index = index;
        }

        @Override
        public int compareTo(SortingIndex o) {
            if (this.key instanceof Double) {
                return ((Double)this.key).compareTo((Double)o.key);
            }
            if (this.key instanceof String) {
                return ((String)this.key).compareTo((String)o.key);
            }
            return 0;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.key + " --> " + this.index;
        }
    }
}

