/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleReader;
import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleExampleExampleSet
extends AbstractExampleSet {
    private ExampleSet parent;
    private Example example;

    public SingleExampleExampleSet(ExampleSet exampleSet, Example example) {
        this.parent = exampleSet;
        this.example = example;
    }

    public SingleExampleExampleSet(SingleExampleExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.example = exampleSet.example;
    }

    @Override
    public Iterator<Example> iterator() {
        return new SingleExampleIterator(this.example.getDataRow(), this);
    }

    @Override
    public Example getExample(int index) {
        if (index == 0) {
            return new Example(this.example.getDataRow(), this);
        }
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Example getExampleFromId(double id) {
        Attribute idAttribute = this.getAttributes().getId();
        if (idAttribute != null) {
            Example newExample = new Example(this.example.getDataRow(), this);
            if (newExample.getValue(idAttribute) == id) {
                return newExample;
            }
            return null;
        }
        return null;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }

    private static class SingleExampleIterator
    extends AbstractExampleReader {
        private boolean nextCalled = false;
        private DataRow dataRow;
        private SingleExampleExampleSet exampleSet;

        public SingleExampleIterator(DataRow dataRow, SingleExampleExampleSet exampleSet) {
            this.dataRow = dataRow;
            this.exampleSet = exampleSet;
        }

        public boolean hasNext() {
            return !this.nextCalled;
        }

        public Example next() {
            if (!this.nextCalled) {
                this.nextCalled = true;
                return new Example(this.dataRow, this.exampleSet);
            }
            return null;
        }
    }
}

