/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.SimpleAttributes;
import edu.udo.cs.yale.example.SimpleExampleReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExampleSet
extends AbstractExampleSet {
    private ExampleTable exampleTable;
    private Attributes attributes = new SimpleAttributes();
    private Map<Double, Integer> idMap = new HashMap<Double, Integer>();

    public SimpleExampleSet(ExampleTable exampleTable) {
        this(exampleTable, null, null);
    }

    public SimpleExampleSet(ExampleTable exampleTable, List<Attribute> regularAttributes) {
        this(exampleTable, regularAttributes, null);
    }

    public SimpleExampleSet(ExampleTable exampleTable, Map<Attribute, String> specialAttributes) {
        this(exampleTable, null, specialAttributes);
    }

    public SimpleExampleSet(ExampleTable exampleTable, List<Attribute> regularAttributes, Map<Attribute, String> specialAttributes) {
        this.exampleTable = exampleTable;
        List<Attribute> regularList = regularAttributes;
        if (regularList == null) {
            regularList = new LinkedList<Attribute>();
            int a = 0;
            while (a < exampleTable.getNumberOfAttributes()) {
                regularList.add(exampleTable.getAttribute(a));
                ++a;
            }
        }
        for (Attribute attribute : regularList) {
            if (specialAttributes != null && specialAttributes.get(attribute) != null) continue;
            this.getAttributes().add(new AttributeRole(attribute));
        }
        if (specialAttributes != null) {
            for (Map.Entry<Attribute, String> entry : specialAttributes.entrySet()) {
                this.getAttributes().setSpecialAttribute(entry.getKey(), entry.getValue());
            }
        }
        this.remapIds();
    }

    public SimpleExampleSet(SimpleExampleSet exampleSet) {
        this.exampleTable = exampleSet.exampleTable;
        this.attributes = (Attributes)exampleSet.getAttributes().clone();
        this.idMap.putAll(exampleSet.idMap);
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    @Override
    public int size() {
        return this.exampleTable.size();
    }

    @Override
    public Iterator<Example> iterator() {
        return new SimpleExampleReader(this.getExampleTable().getDataRowReader(), this);
    }

    @Override
    public Example getExampleFromId(double id) {
        return this.createExample(this.getDataRowFromId(id));
    }

    @Override
    public Example getExample(int index) {
        return this.createExample(this.getExampleTable().getDataRow(index));
    }

    private Example createExample(DataRow dataRow) {
        if (dataRow == null) {
            return null;
        }
        return new Example(dataRow, this);
    }

    private DataRow getDataRowFromId(double id) {
        Integer indexObject = this.idMap.get(id);
        if (indexObject != null) {
            return this.getExampleTable().getDataRow(indexObject);
        }
        return null;
    }

    @Override
    public void remapIds() {
        this.idMap.clear();
        Attribute idAttribute = this.getAttributes().getSpecial("id");
        if (idAttribute != null) {
            DataRowReader reader = this.getExampleTable().getDataRowReader();
            int index = 0;
            while (reader.hasNext()) {
                DataRow dataRow = (DataRow)reader.next();
                this.idMap.put(dataRow.get(idAttribute), index);
                ++index;
            }
        }
    }
}

