/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractDataRowReader;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class SPSSDataRowReader
extends AbstractDataRowReader {
    FileInputStream fileReader = null;
    byte[] readBuffer = new byte[500];
    boolean reverseEndian = false;
    SPSSFileHeader fileHeader = new SPSSFileHeader();
    List<Variable> variables = new LinkedList<Variable>();
    LinkedHashMap<Integer, Integer> variableNrTranslations = new LinkedHashMap();
    AttributeSet attributeSet = null;
    Attribute[] attributes = null;
    Attribute weight = null;
    private boolean eof = false;
    private boolean lineRead = false;
    private double sampleRatio = 1.0;
    private int sampleSize = -1;
    public static final int USE_VAR_NAME = 0;
    public static final int USE_VAR_LABEL = 1;
    public static final int USE_VAR_NAME_LABELED = 2;
    public static final int USE_VAR_LABEL_NAMED = 3;
    public static final String[] ATTRIBUTE_NAMING_MODES = new String[]{"Name", "Label", "Name (Label)", "Label (Name)"};
    private boolean useValueLabels = false;
    private boolean recodeUserMissings = true;
    private int linesRead = 0;
    private int commandCodeCounter = 0;
    String[] data = null;

    public SPSSDataRowReader(DataRowFactory factory, File file, int attributeNamingMode, boolean useValueLabels, boolean recodeUserMissings, double sampleRatio, int sampleSize) throws IOException {
        super(factory);
        boolean terminated;
        this.fileReader = new FileInputStream(file);
        this.useValueLabels = useValueLabels;
        this.recodeUserMissings = recodeUserMissings;
        this.sampleRatio = sampleRatio;
        this.sampleSize = sampleSize;
        int readLength = this.fileReader.read(this.readBuffer, 0, 176);
        this.checkForCorrectLength(readLength, 176);
        if (this.extractInt(this.readBuffer, 0) == 608586802) {
            this.fileHeader.productName = this.extractString(this.readBuffer, 4, 60);
            this.fileHeader.layoutCode = this.extractInt(this.readBuffer, 64);
            if (this.fileHeader.layoutCode != 2) {
                this.reverseEndian = true;
                this.fileHeader.layoutCode = this.extractInt(this.readBuffer, 64);
            }
            this.fileHeader.caseSize = this.extractInt(this.readBuffer, 68);
            this.fileHeader.compressed = this.extractInt(this.readBuffer, 72) == 1;
            this.fileHeader.weightIndex = this.extractInt(this.readBuffer, 76);
            this.fileHeader.numberOfCases = this.extractInt(this.readBuffer, 80);
            this.fileHeader.bias = this.extractDouble(this.readBuffer, 84);
            this.fileHeader.date = this.extractString(this.readBuffer, 92, 9);
            this.fileHeader.time = this.extractString(this.readBuffer, 101, 8);
            this.fileHeader.fileLabel = this.extractString(this.readBuffer, 109, 64);
            StringBuffer logMessage = new StringBuffer("SPSSExampleSource reads " + file.getAbsolutePath() + Tools.getLineSeparator());
            logMessage.append(String.valueOf(this.fileHeader.compressed ? "" : "un") + "compressed, written by  " + this.fileHeader.productName + "  at " + this.fileHeader.time + ", " + this.fileHeader.date + Tools.getLineSeparator());
            if (this.fileHeader.fileLabel.length() == 0) {
                logMessage.append("file label is " + this.fileHeader.fileLabel + Tools.getLineSeparator());
            } else {
                logMessage.append("no file label, ");
            }
            logMessage.append("contains " + this.fileHeader.numberOfCases + " examples, case size is " + this.fileHeader.caseSize + "x8=" + this.fileHeader.caseSize * 8 + " Bytes" + Tools.getLineSeparator());
            logMessage.append("weight index is " + this.fileHeader.weightIndex + Tools.getLineSeparator());
            LogService.logMessage(logMessage.toString(), 0);
        }
        int currVarNr = 0;
        int i = 0;
        while (i < this.fileHeader.caseSize) {
            readLength = this.fileReader.read(this.readBuffer, 0, 32);
            this.checkForCorrectLength(readLength, 32);
            if (this.extractInt(this.readBuffer, 0) != 2) {
                throw new IOException("File corrupt (missing variable definitions)");
            }
            Variable currentVar = new Variable();
            currentVar.type = this.extractInt(this.readBuffer, 4);
            currentVar.labeled = this.extractInt(this.readBuffer, 8) == 1;
            currentVar.numberOfMissingValues = this.extractInt(this.readBuffer, 12);
            currentVar.name = this.extractString(this.readBuffer, 24, 8);
            if (currentVar.labeled) {
                readLength = this.fileReader.read(this.readBuffer, currentVar.length, 4);
                this.checkForCorrectLength(readLength, 4);
                int labelLength = this.extractInt(this.readBuffer, currentVar.length);
                Variable variable = currentVar;
                variable.length = variable.length + 4;
                int adjLabelLength = labelLength;
                if (labelLength % 4 != 0) {
                    adjLabelLength = labelLength + 4 - labelLength % 4;
                }
                readLength = this.fileReader.read(this.readBuffer, currentVar.length, adjLabelLength);
                this.checkForCorrectLength(readLength, adjLabelLength);
                currentVar.label = this.extractString(this.readBuffer, currentVar.length, adjLabelLength);
                Variable variable2 = currentVar;
                variable2.length = variable2.length + adjLabelLength;
            }
            if (currentVar.numberOfMissingValues != 0) {
                readLength = this.fileReader.read(this.readBuffer, currentVar.length, currentVar.numberOfMissingValues * 8);
                this.checkForCorrectLength(readLength, currentVar.numberOfMissingValues * 8);
                currentVar.missingValues = new double[currentVar.numberOfMissingValues];
                int j = 0;
                while (j < currentVar.numberOfMissingValues) {
                    ((Variable)currentVar).missingValues[j] = this.extractDouble(this.readBuffer, currentVar.length + j * 8);
                    ++j;
                }
                Variable variable = currentVar;
                variable.length = variable.length + currentVar.numberOfMissingValues * 8;
            }
            if (currentVar.type != -1) {
                this.variables.add(currentVar);
                this.variableNrTranslations.put(i, currVarNr);
                ++currVarNr;
            }
            ++i;
        }
        boolean valueLabelsRead = false;
        ValueLabels currentValLabels = null;
        block26: do {
            int count = 0;
            terminated = false;
            readLength = this.fileReader.read(this.readBuffer, 0, 4);
            this.checkForCorrectLength(readLength, 4);
            int recordType = this.extractInt(this.readBuffer, 0);
            switch (recordType) {
                case 3: {
                    readLength = this.fileReader.read(this.readBuffer, 4, 4);
                    this.checkForCorrectLength(readLength, 4);
                    count = this.extractInt(this.readBuffer, 4);
                    currentValLabels = new ValueLabels();
                    int i2 = 0;
                    while (i2 < count) {
                        readLength = this.fileReader.read(this.readBuffer, 0, 8);
                        this.checkForCorrectLength(readLength, 8);
                        double labelValue = this.extractDouble(this.readBuffer, 0);
                        readLength = this.fileReader.read(this.readBuffer, 8, 1);
                        this.checkForCorrectLength(readLength, 1);
                        byte labelLength = this.readBuffer[8];
                        int adjLabelLength = labelLength + 8 - labelLength % 8 - 1;
                        readLength = this.fileReader.read(this.readBuffer, 9, adjLabelLength);
                        this.checkForCorrectLength(readLength, adjLabelLength);
                        String labelLabel = this.extractString(this.readBuffer, 9, adjLabelLength);
                        currentValLabels.put(labelValue, labelLabel);
                        ++i2;
                    }
                    valueLabelsRead = true;
                    break;
                }
                case 4: {
                    if (!valueLabelsRead) {
                        throw new IOException("Value labels not read");
                    }
                    valueLabelsRead = false;
                    readLength = this.fileReader.read(this.readBuffer, 0, 4);
                    this.checkForCorrectLength(readLength, 4);
                    count = this.extractInt(this.readBuffer, 0);
                    int i2 = 0;
                    while (i2 < count) {
                        readLength = this.fileReader.read(this.readBuffer, 0, 4);
                        this.checkForCorrectLength(readLength, 4);
                        int varNr = this.variableNrTranslations.get(this.extractInt(this.readBuffer, 0) - 1);
                        if (varNr < this.variables.size()) {
                            Variable var = this.variables.get(varNr);
                            var.valueLabels = currentValLabels;
                        }
                        ++i2;
                    }
                    continue block26;
                }
                case 6: {
                    readLength = this.fileReader.read(this.readBuffer, 4, 4);
                    this.checkForCorrectLength(readLength, 4);
                    count = this.extractInt(this.readBuffer, 4);
                    int i2 = 0;
                    while (i2 < count) {
                        readLength = this.fileReader.read(this.readBuffer, 0, 80);
                        this.checkForCorrectLength(readLength, 80);
                        ++i2;
                    }
                    continue block26;
                }
                case 7: {
                    readLength = this.fileReader.read(this.readBuffer, 4, 12);
                    this.checkForCorrectLength(readLength, 12);
                    int subType = this.extractInt(this.readBuffer, 4);
                    int size = this.extractInt(this.readBuffer, 8);
                    count = this.extractInt(this.readBuffer, 12);
                    switch (subType) {
                        case 3: {
                            readLength = this.fileReader.read(this.readBuffer, 0, 32);
                            this.checkForCorrectLength(readLength, 32);
                            break;
                        }
                        case 4: {
                            readLength = this.fileReader.read(this.readBuffer, 0, 24);
                            this.checkForCorrectLength(readLength, 24);
                            break;
                        }
                        case 11: {
                            int i3 = 0;
                            while (i3 < this.variables.size()) {
                                readLength = this.fileReader.read(this.readBuffer, 0, 12);
                                this.checkForCorrectLength(readLength, 12);
                                Variable var = this.variables.get(i3);
                                var.measure = this.extractInt(this.readBuffer, 0);
                                this.extractInt(this.readBuffer, 4);
                                this.extractInt(this.readBuffer, 8);
                                ++i3;
                            }
                            continue block26;
                        }
                        case 13: {
                            this.readBuffer = new byte[count * size];
                            readLength = this.fileReader.read(this.readBuffer, 0, count * size);
                            this.checkForCorrectLength(readLength, count * size);
                            this.readBuffer = new byte[500];
                            break;
                        }
                        default: {
                            readLength = this.fileReader.read(this.readBuffer, 0, count * size);
                            this.checkForCorrectLength(readLength, count * size);
                            break;
                        }
                    }
                    continue block26;
                }
                case 999: {
                    readLength = this.fileReader.read(this.readBuffer, 4, 4);
                    this.checkForCorrectLength(readLength, 4);
                    terminated = true;
                    break;
                }
            }
        } while (!terminated);
        this.attributeSet = new AttributeSet();
        Attribute attribute = null;
        int i4 = 0;
        while (i4 < this.variables.size()) {
            Variable var = this.variables.get(i4);
            String varName = null;
            switch (attributeNamingMode) {
                case 0: {
                    varName = var.name;
                    break;
                }
                case 1: {
                    varName = var.label;
                    break;
                }
                case 2: {
                    varName = String.valueOf(var.name) + " (" + var.label + ")";
                    break;
                }
                case 3: {
                    varName = String.valueOf(var.label) + " (" + var.name + ")";
                    break;
                }
                default: {
                    varName = var.name;
                }
            }
            if (var.type == 0) {
                switch (var.measure) {
                    case 1: {
                        attribute = AttributeFactory.createAttribute(varName, 1);
                        break;
                    }
                    case 2: {
                        attribute = AttributeFactory.createAttribute(varName, 6);
                        break;
                    }
                    case 3: {
                        attribute = AttributeFactory.createAttribute(varName, 2);
                        break;
                    }
                    default: {
                        attribute = AttributeFactory.createAttribute(varName, 2);
                        break;
                    }
                }
            } else {
                attribute = AttributeFactory.createAttribute(varName, 5);
            }
            if (var.type == 0 && var.measure != 3 && var.valueLabels != null) {
                for (Double numValue : var.valueLabels.keySet()) {
                    boolean missing = false;
                    if (recodeUserMissings) {
                        int j = 0;
                        while (j < var.numberOfMissingValues) {
                            if (numValue == var.missingValues[j]) {
                                missing = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (missing) continue;
                    if (useValueLabels) {
                        attribute.getMapping().mapString((String)var.valueLabels.get(numValue));
                        continue;
                    }
                    attribute.getMapping().mapString(Double.toString(numValue));
                }
            }
            this.attributeSet.addAttribute(attribute);
            ++i4;
        }
        Object[] obj = this.attributeSet.getAllAttributes().toArray();
        this.attributes = new Attribute[obj.length];
        int i5 = 0;
        while (i5 < obj.length) {
            this.attributes[i5] = (Attribute)obj[i5];
            ++i5;
        }
        if (this.fileHeader.weightIndex != 0) {
            this.weight = this.attributes[this.variableNrTranslations.get(this.fileHeader.weightIndex - 1)];
        }
    }

    private void checkForCorrectLength(int actualLength, int targetLength) throws IOException {
        if (actualLength != targetLength) {
            throw new IOException("SPSSReader: wrong byte length");
        }
    }

    private int extractInt(byte[] value, int offset) {
        int r = 0;
        if (this.reverseEndian) {
            int i = offset + 3;
            while (i >= offset) {
                r <<= 8;
                r += 0xFF & value[i];
                --i;
            }
        } else {
            int i = offset;
            while (i < offset + 4) {
                r <<= 8;
                r += 0xFF & value[i];
                ++i;
            }
        }
        return r;
    }

    private double extractDouble(byte[] value, int offset) {
        long bits = 0L;
        if (this.reverseEndian) {
            int i = offset + 7;
            while (i >= offset) {
                bits <<= 8;
                bits += (long)(0xFF & value[i]);
                --i;
            }
        } else {
            int i = offset;
            while (i < offset + 8) {
                bits <<= 8;
                bits += (long)(0xFF & value[i]);
                ++i;
            }
        }
        return Double.longBitsToDouble(bits);
    }

    private String extractString(byte[] value, int offset, int length) {
        return new String(value, offset, length).trim();
    }

    private String[] readLine() throws IOException {
        int bytesRead = 0;
        String[] strings = new String[this.variables.size()];
        if (this.fileHeader.compressed) {
            int i = 0;
            while (i < this.variables.size()) {
                boolean readValue = false;
                String value = null;
                do {
                    if (this.commandCodeCounter % 8 == 0) {
                        bytesRead = this.fileReader.read(this.readBuffer, 0, 8);
                        if (bytesRead == -1) {
                            this.eof = true;
                            strings = null;
                            break;
                        }
                        this.commandCodeCounter = 0;
                    }
                    int commandCode = 0xFF & this.readBuffer[this.commandCodeCounter];
                    switch (commandCode) {
                        case 0: {
                            break;
                        }
                        case 252: {
                            int j = this.commandCodeCounter + 1;
                            while (j < 8) {
                                this.readBuffer[j] = 0;
                                ++j;
                            }
                            this.eof = true;
                            break;
                        }
                        case 253: {
                            bytesRead = this.fileReader.read(this.readBuffer, 8, 8);
                            if (bytesRead == -1) {
                                throw new IOException("File corrupt (data inconsistency)");
                            }
                            if (this.variables.get(i).type == 0) {
                                value = Double.toString(this.extractDouble(this.readBuffer, 8));
                                readValue = true;
                                break;
                            }
                            if ((value = value == null ? new String(this.readBuffer, 8, 8) : String.valueOf(value) + new String(this.readBuffer, 8, 8)).length() < this.variables.get(i).type) break;
                            value = value.trim();
                            readValue = true;
                            break;
                        }
                        case 254: {
                            value = value == null ? "        " : String.valueOf(value) + "        ";
                            if (value.length() < this.variables.get(i).type) break;
                            value = value.trim();
                            readValue = true;
                            break;
                        }
                        case 255: {
                            value = null;
                            readValue = true;
                            break;
                        }
                        default: {
                            double numValue = (double)commandCode - this.fileHeader.bias;
                            Variable currVar = this.variables.get(i);
                            value = Double.toString(numValue);
                            if (currVar.measure != 3 && this.useValueLabels && currVar.valueLabels != null) {
                                String label;
                                value = label = (String)currVar.valueLabels.get(numValue);
                            }
                            if (this.recodeUserMissings) {
                                int j = 0;
                                while (j < currVar.numberOfMissingValues) {
                                    if (Tools.isEqual(numValue, currVar.missingValues[j])) {
                                        value = null;
                                    }
                                    ++j;
                                }
                            }
                            readValue = true;
                        }
                    }
                    ++this.commandCodeCounter;
                    if (!readValue) continue;
                    strings[i] = value;
                    break;
                } while (!this.eof);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.variables.size()) {
                bytesRead = this.fileReader.read(this.readBuffer, 0, 8);
                strings[i] = Double.toString(this.extractDouble(this.readBuffer, 8));
                ++i;
            }
        }
        return strings;
    }

    public boolean hasNext() {
        if (this.lineRead) {
            return !this.eof;
        }
        if (this.sampleSize > -1 && this.linesRead >= this.sampleSize) {
            return false;
        }
        try {
            boolean ok = false;
            while (!ok) {
                this.data = this.readLine();
                if (this.eof) {
                    try {
                        this.fileReader.close();
                    }
                    catch (IOException e) {
                        LogService.logMessage(e.getMessage(), 6);
                    }
                }
                if (!this.eof && this.sampleSize == -1 && this.sampleRatio != 1.0 && !(RandomGenerator.getGlobalRandomGenerator().nextDouble() < this.sampleRatio)) continue;
                ok = true;
            }
        }
        catch (IOException e) {
            LogService.logMessage(e.getMessage(), 6);
            return false;
        }
        this.lineRead = true;
        return !this.eof;
    }

    public DataRow next() {
        if (this.eof) {
            return null;
        }
        if (!this.lineRead && !this.hasNext()) {
            return null;
        }
        DataRow dataRow = this.getFactory().create(this.data, this.attributes);
        ++this.linesRead;
        this.lineRead = false;
        return dataRow;
    }

    public ExampleSet getExampleSet() {
        MemoryExampleTable table = new MemoryExampleTable(this.attributeSet.getAllAttributes(), this);
        ExampleSet exampleSet = table.createExampleSet(this.attributeSet);
        if (this.weight != null) {
            AttributeRole role = exampleSet.getAttributes().getRole(this.weight);
            role.setSpecial("weight");
        }
        return exampleSet;
    }

    private static class SPSSFileHeader {
        private static final int RECORD_NR = 608586802;
        private static final int LENGTH = 176;
        private String productName;
        private int layoutCode;
        private int caseSize;
        private boolean compressed;
        private int weightIndex;
        private int numberOfCases;
        private double bias;
        private String date;
        private String time;
        private String fileLabel;

        private SPSSFileHeader() {
        }
    }

    private static class Variable {
        private static final int LENGTH = 32;
        private static final int NOMINAL = 1;
        private static final int ORDINAL = 2;
        private static final int CONTINUOUS = 3;
        private int type;
        private boolean labeled;
        private int numberOfMissingValues;
        private String name;
        private String label;
        private int length = 32;
        private double[] missingValues;
        private ValueLabels valueLabels;
        private int measure;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueLabels
    extends LinkedHashMap<Double, String> {
        private static final long serialVersionUID = 42L;
        private static final int RECORD_NR = 3;

        private ValueLabels() {
        }
    }

    private static class ValueLabelVariable {
        private static final int RECORD_NR = 4;

        private ValueLabelVariable() {
        }
    }

    private static class Document {
        private static final int RECORD_NR = 6;

        private Document() {
        }
    }

    private static class DictionaryTermination {
        private static final int RECORD_NR = 999;

        private DictionaryTermination() {
        }
    }
}

