/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractDataRowReader;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.DatabaseDataRow;
import edu.udo.cs.yale.tools.LogService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetDataRowReader
extends AbstractDataRowReader {
    private Attribute[] attributes;
    private ResultSet resultSet;
    private static final int DONT_KNOW_YET = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private int hasNext = 0;

    public ResultSetDataRowReader(DataRowFactory dataRowFactory, List<Attribute> attributeList, ResultSet resultSet) {
        super(dataRowFactory);
        this.resultSet = resultSet;
        this.attributes = new Attribute[attributeList.size()];
        attributeList.toArray(this.attributes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNext() {
        switch (this.hasNext) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: {
                try {
                    if (this.resultSet.next()) {
                        this.hasNext = 1;
                        return true;
                    }
                    this.hasNext = 2;
                    this.resultSet.close();
                    return false;
                }
                catch (SQLException e) {
                    LogService.logException("While reading examples from result set:", null, e);
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public DataRow next() {
        if (this.hasNext()) {
            this.hasNext = 0;
            try {
                double[] data = new double[this.resultSet.getMetaData().getColumnCount()];
                DataRow row = this.getFactory().create(this.attributes.length);
                int i = 0;
                while (i < data.length) {
                    row.set(this.attributes[i], DatabaseDataRow.readColumn(this.resultSet, this.attributes[i]));
                    ++i;
                }
                return row;
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Error accessing the result of a query:" + sqle.toString());
            }
        }
        return null;
    }
}

