/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleTable;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.example.RandomDataRowReader;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomExampleTable
extends AbstractExampleTable {
    private int size;

    public RandomExampleTable(List<Attribute> attributes, int size) {
        super(attributes);
        this.size = size;
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new RandomDataRowReader(this.getAttributes(), this.size);
    }

    @Override
    public DataRow getDataRow(int index) {
        RandomGenerator random = RandomGenerator.getRandomGenerator(-1);
        double[] data = new double[this.size];
        int i = 0;
        while (i < data.length) {
            NumericalAttributeStatistics stats = (NumericalAttributeStatistics)this.getAttributes()[i].getStatistics();
            data[i] = random.nextDoubleInRange(stats.getMinimum(), stats.getMaximum());
            ++i;
        }
        return new DoubleArrayDataRow(data);
    }

    @Override
    public int size() {
        return this.size;
    }
}

