/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractDataRowReader;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import edu.udo.cs.yale.tools.RandomGenerator;

public class RandomDataRowReader
extends AbstractDataRowReader {
    private int size;
    private Attribute[] attributes;
    private int counter = 0;

    public RandomDataRowReader(Attribute[] attributes, int size) {
        super(new DataRowFactory(0, '.'));
        this.attributes = attributes;
        this.size = size;
    }

    public boolean hasNext() {
        return this.counter < this.size;
    }

    public DataRow next() {
        RandomGenerator random = RandomGenerator.getRandomGenerator(-1);
        double[] data = new double[this.attributes.length];
        int i = 0;
        while (i < data.length) {
            NumericalAttributeStatistics stats = (NumericalAttributeStatistics)this.attributes[i].getStatistics();
            data[i] = random.nextDoubleInRange(stats.getMinimum(), stats.getMaximum());
            ++i;
        }
        return new DoubleArrayDataRow(data);
    }
}

