/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.NominalMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolynominalMapping
implements NominalMapping {
    private Map<String, Integer> symbolToIndexMap = new HashMap<String, Integer>();
    private List<String> indexToSymbolMap = new ArrayList<String>();

    public PolynominalMapping() {
    }

    private PolynominalMapping(PolynominalMapping mapping) {
        this.symbolToIndexMap.clear();
        this.symbolToIndexMap.putAll(mapping.symbolToIndexMap);
        this.indexToSymbolMap.clear();
        this.indexToSymbolMap.addAll(mapping.indexToSymbolMap);
    }

    PolynominalMapping(NominalMapping mapping) {
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
        int i = 0;
        while (i < mapping.size()) {
            int index = i++;
            String value = mapping.mapIndex(index);
            this.symbolToIndexMap.put(value, index);
            this.indexToSymbolMap.add(value);
        }
    }

    @Override
    public Object clone() {
        return new PolynominalMapping(this);
    }

    @Override
    public int mapString(String str) {
        if (str == null) {
            return -1;
        }
        int index = this.getIndex(str);
        if (index < 0) {
            this.indexToSymbolMap.add(str);
            index = this.indexToSymbolMap.size() - 1;
            this.symbolToIndexMap.put(str, index);
        }
        return index;
    }

    @Override
    public int getIndex(String str) {
        Integer index = this.symbolToIndexMap.get(str);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public String mapIndex(int index) {
        if (index < 0 || index >= this.indexToSymbolMap.size()) {
            throw new RuntimeException("Cannot map index of nominal attribute to nominal value: index " + index + " is out of bounds!");
        }
        return this.indexToSymbolMap.get(index);
    }

    @Override
    public void setMapping(String nominalValue, int index) {
        String oldValue = this.indexToSymbolMap.get(index);
        this.indexToSymbolMap.set(index, nominalValue);
        this.symbolToIndexMap.remove(oldValue);
        this.symbolToIndexMap.put(nominalValue, index);
    }

    @Override
    public int getNegativeIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new RuntimeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        return 0;
    }

    @Override
    public int getPositiveIndex() {
        this.ensureClassification();
        if (this.mapIndex(0) == null) {
            throw new RuntimeException("Attribute: Cannot use FIRST_CLASS_INDEX for negative class!");
        }
        for (int index : this.symbolToIndexMap.values()) {
            if (index == 0) continue;
            return index;
        }
        throw new RuntimeException("Attribute: No other class than FIRST_CLASS_INDEX found!");
    }

    @Override
    public String getNegativeString() {
        return this.mapIndex(this.getNegativeIndex());
    }

    @Override
    public String getPositiveString() {
        return this.mapIndex(this.getPositiveIndex());
    }

    @Override
    public List<String> getValues() {
        return this.indexToSymbolMap;
    }

    @Override
    public int size() {
        return this.indexToSymbolMap.size();
    }

    @Override
    public void sortMappings() {
        LinkedList allStrings = new LinkedList(this.symbolToIndexMap.keySet());
        Collections.sort(allStrings);
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
        Iterator i = allStrings.iterator();
        while (i.hasNext()) {
            this.mapString((String)i.next());
        }
    }

    @Override
    public void clear() {
        this.symbolToIndexMap.clear();
        this.indexToSymbolMap.clear();
    }

    private void ensureClassification() {
        if (this.size() != 2) {
            throw new RuntimeException("Attribute " + this.toString() + " is not a classification attribute!");
        }
    }
}

