/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.NominalAttribute;
import edu.udo.cs.yale.example.NominalMapping;
import edu.udo.cs.yale.example.PolynominalMapping;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;

public class PolynominalAttribute
extends NominalAttribute {
    private static final int MAX_NUMBER_OF_SHOWN_NOMINAL_VALUES = 100;
    private NominalMapping nominalMapping = new PolynominalMapping();

    PolynominalAttribute(String name) {
        this(name, 1);
    }

    PolynominalAttribute(String name, int valueType) {
        super(name, valueType);
    }

    private PolynominalAttribute(PolynominalAttribute a) {
        super(a.getName(), a.getValueType());
        this.nominalMapping = (NominalMapping)a.nominalMapping.clone();
    }

    public Object clone() {
        return new PolynominalAttribute(this);
    }

    public NominalMapping getMapping() {
        return this.nominalMapping;
    }

    public void setMapping(NominalMapping newMapping) {
        this.nominalMapping = new PolynominalMapping(newMapping);
    }

    public void writeAttributeData(DataOutput out) throws IOException {
        super.writeAttributeData(out);
        out.writeInt(this.nominalMapping.size());
        Iterator<String> i = this.nominalMapping.getValues().iterator();
        while (i.hasNext()) {
            out.writeUTF(i.next());
        }
    }

    public void readAttributeData(DataInput in) throws IOException {
        super.readAttributeData(in);
        int num = in.readInt();
        int i = 0;
        while (i < num) {
            this.nominalMapping.mapString(in.readUTF());
            ++i;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("/values=[");
        Iterator<String> i = this.nominalMapping.getValues().iterator();
        int index = 0;
        while (i.hasNext()) {
            if (index >= 100) {
                result.append(", ... (" + (this.nominalMapping.getValues().size() - 100) + " values) ...");
                break;
            }
            if (index != 0) {
                result.append(", ");
            }
            result.append(i.next());
            ++index;
        }
        result.append("]");
        return result.toString();
    }
}

