/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.PartitionBuilder;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;

public class Partition
implements Cloneable {
    private boolean[] mask;
    private int[] partitionSizes;
    private int[] splitPartition;
    private int[] tableIndexMap = null;

    public Partition(double[] ratio, int size, PartitionBuilder builder) {
        this.init(ratio, size, builder);
    }

    public Partition(int noPartitions, int size, PartitionBuilder builder) {
        double[] ratio = new double[noPartitions];
        int i = 0;
        while (i < ratio.length) {
            ratio[i] = 1.0 / (double)noPartitions;
            ++i;
        }
        this.init(ratio, size, builder);
    }

    public Partition(int[] splitPartition, int numberOfPartitions) {
        this.init(splitPartition, numberOfPartitions);
    }

    private Partition(Partition p) {
        this.partitionSizes = (int[])p.partitionSizes.clone();
        this.mask = (boolean[])p.mask.clone();
        this.splitPartition = (int[])p.splitPartition.clone();
        this.recalculateTableIndices();
    }

    private void init(double[] ratio, int size, PartitionBuilder builder) {
        LogService.logMessage("Create new partition using a '" + builder.getClass().getName() + "'.", 2);
        this.splitPartition = builder.createPartition(ratio, size);
        this.init(this.splitPartition, ratio.length);
    }

    private void init(int[] elements, int noOfPartitions) {
        LogService.logMessage("Create new partition with " + elements.length + " elements and " + noOfPartitions + " partitions.", 2);
        this.partitionSizes = new int[noOfPartitions];
        this.splitPartition = elements;
        int i = 0;
        while (i < this.splitPartition.length) {
            if (this.splitPartition[i] >= 0) {
                int n = this.splitPartition[i];
                this.partitionSizes[n] = this.partitionSizes[n] + 1;
            }
            ++i;
        }
        this.mask = new boolean[noOfPartitions];
        i = 0;
        while (i < this.mask.length) {
            this.mask[i] = true;
            ++i;
        }
        this.recalculateTableIndices();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)o;
        int i = 0;
        while (i < this.mask.length) {
            if (this.mask[i] != other.mask[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.splitPartition.length) {
            if (this.splitPartition[i] != other.splitPartition[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.mask.length;
        int i = 0;
        while (i < this.mask.length) {
            hc = hc * hashMultiplier + Boolean.valueOf(this.mask[i]).hashCode();
            i <<= 1;
        }
        hc = hc * hashMultiplier + this.splitPartition.length;
        i = 0;
        while (i < this.splitPartition.length) {
            hc = hc * hashMultiplier + Integer.valueOf(this.splitPartition[i]).hashCode();
            i <<= 1;
        }
        return hc;
    }

    public void clearSelection() {
        this.mask = new boolean[this.mask.length];
        this.recalculateTableIndices();
    }

    public void invertSelection() {
        int i = 0;
        while (i < this.mask.length) {
            this.mask[i] = !this.mask[i];
            ++i;
        }
        this.recalculateTableIndices();
    }

    public void selectSubset(int i) {
        this.mask[i] = true;
        this.recalculateTableIndices();
    }

    public void deselectSubset(int i) {
        this.mask[i] = false;
        this.recalculateTableIndices();
    }

    public int getNumberOfSubsets() {
        return this.partitionSizes.length;
    }

    public int getSelectionSize() {
        int s = 0;
        int i = 0;
        while (i < this.partitionSizes.length) {
            if (this.mask[i]) {
                s += this.partitionSizes[i];
            }
            ++i;
        }
        return s;
    }

    public int getTotalSize() {
        return this.splitPartition.length;
    }

    public boolean isSelected(int index) {
        return this.mask[this.splitPartition[index]];
    }

    private void recalculateTableIndices() {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        while (i < this.splitPartition.length) {
            if (this.mask[this.splitPartition[i]]) {
                indices.add(i);
            }
            ++i;
        }
        this.tableIndexMap = new int[indices.size()];
        Iterator i2 = indices.iterator();
        int counter = 0;
        while (i2.hasNext()) {
            this.tableIndexMap[counter++] = (Integer)i2.next();
        }
    }

    public int mapIndex(int index) {
        return this.tableIndexMap[index];
    }

    public String toString() {
        String str = "(";
        int i = 0;
        while (i < this.partitionSizes.length) {
            str = String.valueOf(str) + (i != 0 ? "/" : "") + this.partitionSizes[i];
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public Object clone() {
        return new Partition(this);
    }
}

