/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.UnknownAttributeStatistics;
import edu.udo.cs.yale.tools.Tools;

public class NumericalAttributeStatistics
extends UnknownAttributeStatistics {
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;
    private double average = 0.0;
    private double squaredSum = 0.0;
    private int valueCounter = 0;

    public void addValue(double value) {
        if (this.minimum > value) {
            this.minimum = value;
        }
        if (this.maximum < value) {
            this.maximum = value;
        }
        this.average += value;
        this.squaredSum += value * value;
        ++this.valueCounter;
    }

    public String getDescription() {
        StringBuffer str = new StringBuffer();
        str.append("avg = " + Tools.formatNumber(this.getAverage()) + " +/- " + Tools.formatNumber(Math.sqrt(this.getVariance())) + "; range = [" + Tools.formatNumber(this.getMinimum()) + " ; " + Tools.formatNumber(this.getMaximum()) + "]");
        int unknownCounter = this.getUnknown();
        if (unknownCounter > 0) {
            str.append("; unknown values = " + unknownCounter);
        }
        return str.toString();
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getAverage() {
        return this.average / (double)this.valueCounter;
    }

    public double getVariance() {
        return this.squaredSum / (double)this.valueCounter - this.getAverage() * this.getAverage();
    }
}

