/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractAttribute;
import edu.udo.cs.yale.example.NominalMapping;
import edu.udo.cs.yale.tools.Tools;

public class NumericalAttribute
extends AbstractAttribute {
    NumericalAttribute(String name) {
        this(name, 2);
    }

    NumericalAttribute(String name, int valueType) {
        super(name, valueType);
    }

    private NumericalAttribute(NumericalAttribute a) {
        super(a.getName(), a.getValueType());
    }

    public Object clone() {
        return new NumericalAttribute(this);
    }

    public boolean isNominal() {
        return false;
    }

    public NominalMapping getMapping() {
        throw new UnsupportedOperationException("The method getNominalMapping() is not supported by numerical attributes!");
    }

    public void setMapping(NominalMapping mapping) {
    }

    public String getAsString(double value, int numberOfDigits) {
        if (Double.isNaN(value)) {
            return "?";
        }
        return numberOfDigits >= 0 ? Tools.formatIntegerIfPossible(value, numberOfDigits) : Tools.formatIntegerIfPossible(value);
    }
}

