/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.AttributeRole;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.AttributesExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSpecialAttributesExampleSet
extends AbstractExampleSet {
    private ExampleSet parent;
    private Attributes attributes;

    public NonSpecialAttributesExampleSet(ExampleSet delegate) {
        this.parent = delegate;
        this.attributes = (Attributes)delegate.getAttributes().clone();
        Iterator<AttributeRole> s = this.attributes.specialAttributes();
        while (s.hasNext()) {
            AttributeRole attributeRole = s.next();
            if (!attributeRole.isSpecial()) continue;
            attributeRole.changeToRegular();
        }
    }

    public NonSpecialAttributesExampleSet(NonSpecialAttributesExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.attributes = (Attributes)exampleSet.attributes.clone();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Iterator<Example> iterator() {
        return new AttributesExampleReader(this.parent.iterator(), this);
    }

    @Override
    public Example getExample(int index) {
        return new Example(this.parent.getExample(index).getDataRow(), this);
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public int size() {
        return this.parent.size();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }
}

