/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.UnknownAttributeStatistics;
import java.util.Iterator;

public class NominalAttributeStatistics
extends UnknownAttributeStatistics {
    private int mode = -1;
    private int maxCounter = 0;
    private int[] scores;
    private Attribute attribute;

    NominalAttributeStatistics(Attribute attribute) {
        this.attribute = attribute;
        this.scores = new int[attribute.getMapping().size()];
    }

    public void addHit(int index) {
        if (index >= this.scores.length) {
            int[] newScores = new int[index + 1];
            System.arraycopy(this.scores, 0, newScores, 0, this.scores.length);
            this.scores = newScores;
        }
        int n = index;
        this.scores[n] = this.scores[n] + 1;
        if (this.scores[index] > this.maxCounter) {
            this.maxCounter = this.scores[index];
            this.mode = index;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public String getModeAsString() {
        if (this.mode < 0) {
            return "?";
        }
        return this.attribute.getMapping().mapIndex(this.mode);
    }

    public int getValueCount(String value) {
        int index = this.attribute.getMapping().getIndex(value);
        if (index < 0) {
            return -1;
        }
        return this.scores[index];
    }

    public String getDescription() {
        StringBuffer str = new StringBuffer();
        str.append("mode = " + this.getModeAsString() + " (" + this.getValueCount(this.getModeAsString()) + "); ");
        int unknownCounter = this.getUnknown();
        if (unknownCounter > 0) {
            str.append("unknown = " + unknownCounter + "; ");
        }
        Iterator<String> i = this.attribute.getMapping().getValues().iterator();
        int n = 0;
        while (i.hasNext()) {
            if (n > 0) {
                str.append(", ");
            }
            ++n;
            String value = i.next();
            str.append(value);
            str.append(" (" + this.getValueCount(value) + ")");
        }
        return str.toString();
    }
}

