/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleTable;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryExampleTable
extends AbstractExampleTable {
    private List<DataRow> dataList = new ArrayList<DataRow>();
    private int columns;
    private static final int INCREMENT = 10;

    public MemoryExampleTable(List<Attribute> attributes) {
        super(attributes);
        this.columns = attributes.size();
    }

    public MemoryExampleTable(List<Attribute> attributes, int size) {
        this(attributes);
        this.dataList = new ArrayList<DataRow>(size);
        int i = 0;
        while (i < size) {
            double[] row = new double[this.columns];
            int j = 0;
            while (j < row.length) {
                row[j] = Double.NaN;
                ++j;
            }
            this.dataList.add(new DoubleArrayDataRow(row));
            ++i;
        }
    }

    public MemoryExampleTable(List<Attribute> attributes, DataRowReader i) {
        this(attributes, i, false);
    }

    public MemoryExampleTable(List<Attribute> attributes, DataRowReader i, boolean permutate) {
        this(attributes);
        this.readExamples(i, permutate);
    }

    public void readExamples(DataRowReader i) {
        this.readExamples(i, false);
    }

    public void readExamples(DataRowReader i, boolean permutate) {
        this.readExamples(i, false, null);
    }

    public void readExamples(DataRowReader i, boolean permutate, Random random) {
        this.dataList.clear();
        while (i.hasNext()) {
            if (permutate) {
                int index = random.nextInt(this.dataList.size() + 1);
                this.dataList.add(index, (DataRow)i.next());
                continue;
            }
            this.dataList.add((DataRow)i.next());
        }
    }

    @Override
    public DataRowReader getDataRowReader() {
        return new ListDataRowReader(this.dataList.iterator());
    }

    @Override
    public DataRow getDataRow(int index) {
        return this.dataList.get(index);
    }

    @Override
    public int size() {
        return this.dataList.size();
    }

    public void addDataRow(DataRow dataRow) {
        this.dataList.add(dataRow);
    }

    @Override
    public int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.dataList == null) {
            return index;
        }
        int n = this.getNumberOfAttributes();
        if (n <= this.columns) {
            return index;
        }
        int newSize = n + 10;
        LogService.logMessage("Resizing example table from " + this.columns + " to " + newSize + " columns.", 2);
        this.columns = newSize;
        if (this.dataList != null) {
            Iterator<DataRow> i = this.dataList.iterator();
            while (i.hasNext()) {
                i.next().ensureNumberOfColumns(this.columns);
            }
        }
        return index;
    }
}

