/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MappedExampleReader;
import edu.udo.cs.yale.example.NumericalAttributeStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedExampleSet
extends AbstractExampleSet {
    private ExampleSet parent;
    private int[] mapping;

    public MappedExampleSet(ExampleSet parent, int[] mapping) {
        this(parent, mapping, true);
    }

    public MappedExampleSet(ExampleSet parent, int[] mapping, boolean useMappedExamples) {
        this.parent = parent;
        this.mapping = mapping;
        Arrays.sort(this.mapping);
        if (!useMappedExamples) {
            ArrayList<Integer> inverseIndexList = new ArrayList<Integer>();
            int currentExample = -1;
            int[] nArray = mapping;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int m = nArray[n];
                if (m != currentExample) {
                    int z = currentExample + 1;
                    while (z < m) {
                        inverseIndexList.add(z);
                        ++z;
                    }
                    currentExample = m;
                }
                ++n;
            }
            this.mapping = new int[inverseIndexList.size()];
            Iterator i = inverseIndexList.iterator();
            int index = 0;
            while (i.hasNext()) {
                this.mapping[index++] = (Integer)i.next();
            }
        }
    }

    public MappedExampleSet(MappedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.mapping = exampleSet.mapping;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MappedExampleSet)) {
            return false;
        }
        MappedExampleSet other = (MappedExampleSet)o;
        if (this.mapping.length != other.mapping.length) {
            return false;
        }
        int i = 0;
        while (i < this.mapping.length) {
            if (this.mapping[i] != other.mapping[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.mapping.hashCode();
    }

    @Override
    public Iterator<Example> iterator() {
        return new MappedExampleReader(this.parent.iterator(), this.mapping);
    }

    @Override
    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the mapped ExampleSet!");
        }
        return this.parent.getExample(this.mapping[index]);
    }

    @Override
    public int size() {
        return this.mapping.length;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }

    public static int[] createBootstrappingMapping(ExampleSet exampleSet, int size, Random random) {
        int[] mapping = new int[size];
        int i = 0;
        while (i < mapping.length) {
            mapping[i] = random.nextInt(exampleSet.size());
            ++i;
        }
        return mapping;
    }

    public static int[] createWeightedBootstrappingMapping(ExampleSet exampleSet, int size, Random random) {
        Attribute weightAttribute = exampleSet.getAttributes().getSpecial("weight");
        exampleSet.recalculateAttributeStatistics(weightAttribute);
        double maxWeight = ((NumericalAttributeStatistics)weightAttribute.getStatistics()).getMaximum();
        int[] mapping = new int[size];
        int i = 0;
        while (i < mapping.length) {
            int index = -1;
            do {
                index = random.nextInt(exampleSet.size());
                Example example = exampleSet.getExample(index);
                double currentWeight = example.getValue(weightAttribute);
                if (!(random.nextDouble() > currentWeight / maxWeight)) continue;
                index = -1;
            } while (index == -1);
            mapping[i] = index;
            ++i;
        }
        return mapping;
    }
}

