/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleReader;
import edu.udo.cs.yale.example.Example;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedExampleReader
extends AbstractExampleReader {
    private Iterator<Example> parent;
    private int[] mapping;
    private Example currentExample;
    private boolean nextInvoked = true;
    private int index = -1;

    public MappedExampleReader(Iterator<Example> parent, int[] mapping) {
        this.parent = parent;
        this.currentExample = null;
        this.mapping = mapping;
    }

    @Override
    public boolean hasNext() {
        if (this.nextInvoked) {
            this.nextInvoked = false;
            int oldMapping = -1;
            if (this.index >= this.mapping.length - 1) {
                return false;
            }
            if (this.index != -1) {
                oldMapping = this.mapping[this.index];
            }
            ++this.index;
            int newMapping = this.mapping[this.index];
            if (newMapping != oldMapping) {
                do {
                    if (!this.parent.hasNext()) {
                        return false;
                    }
                    this.currentExample = this.parent.next();
                } while (++oldMapping < newMapping);
            } else {
                return true;
            }
        }
        return true;
    }

    @Override
    public Example next() {
        if (this.hasNext()) {
            this.nextInvoked = true;
            return this.currentExample;
        }
        return null;
    }
}

