/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractSparseArrayDataRow;

public class FloatSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private float[] values;

    public FloatSparseArrayDataRow() {
        this(0);
    }

    public FloatSparseArrayDataRow(int size) {
        super(size);
        this.values = new float[size];
    }

    protected void swapValues(int a, int b) {
        float tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    public void resizeValues(int length) {
        float[] d = new float[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, double v) {
        this.values[index] = (float)v;
    }

    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.values[i];
            ++i;
        }
        return result;
    }
}

