/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SparseDataRow;
import edu.udo.cs.yale.example.Tools;
import java.util.Arrays;
import java.util.Iterator;

public class FastExample2SparseTransform {
    private int[] mapping;
    private Attribute[] attributes;

    public FastExample2SparseTransform(ExampleSet es) {
        this.mapping = new int[es.getExampleTable().getNumberOfAttributes()];
        int pointertemp = this.mapping.length - 1;
        while (pointertemp != -1) {
            this.mapping[pointertemp--] = -1;
        }
        int pos = 0;
        this.attributes = new Attribute[es.getAttributes().size()];
        for (Attribute attribute : es.getAttributes()) {
            this.mapping[attribute.getTableIndex()] = pos;
            this.attributes[pos] = attribute;
            ++pos;
        }
        Iterator i = es.iterator();
        while (i.hasNext()) {
            DataRow row = ((Example)i.next()).getDataRow();
            row.trim();
        }
    }

    public int[] getNonDefaultAttributeIndices(Example example) {
        int numberNonDefaultAttributes = 0;
        DataRow data = example.getDataRow();
        if (data instanceof SparseDataRow) {
            int[] nonDefaultInd = ((SparseDataRow)((Object)data)).getNonDefaultIndices();
            int[] tempArray = new int[nonDefaultInd.length];
            int i = 0;
            while (i < nonDefaultInd.length) {
                int nextPos = this.mapping[nonDefaultInd[i]];
                if (nextPos != -1) {
                    tempArray[numberNonDefaultAttributes++] = nextPos;
                }
                ++i;
            }
            int[] finalArray = new int[numberNonDefaultAttributes];
            System.arraycopy(tempArray, 0, finalArray, 0, numberNonDefaultAttributes);
            Arrays.sort(finalArray);
            return finalArray;
        }
        int[] tempArray = new int[example.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : example.getAttributes()) {
            double value = example.getValue(attribute);
            if (Tools.isDefault(attribute.getDefault(), value)) continue;
            tempArray[numberNonDefaultAttributes++] = counter++;
        }
        int[] finalArray = new int[numberNonDefaultAttributes];
        System.arraycopy(tempArray, 0, finalArray, 0, numberNonDefaultAttributes);
        return finalArray;
    }

    public double[] getNonDefaultAttributeValues(Example example) {
        return this.getNonDefaultAttributeValues(example, this.getNonDefaultAttributeIndices(example));
    }

    public double[] getNonDefaultAttributeValues(Example example, int[] nonDefaultIndices) {
        double[] result = new double[nonDefaultIndices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = example.getValue(this.attributes[nonDefaultIndices[i]]);
            ++i;
        }
        return result;
    }
}

