/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.Tools;
import java.util.Iterator;

public class Example {
    public static final String SEPARATOR = " ";
    public static final String SPARSE_SEPARATOR = ":";
    private DataRow data;
    private ExampleSet parentExampleSet;

    Example(DataRow data, ExampleSet parentExampleSet) {
        this.data = data;
        this.parentExampleSet = parentExampleSet;
    }

    public DataRow getDataRow() {
        return this.data;
    }

    public Attributes getAttributes() {
        return this.parentExampleSet.getAttributes();
    }

    public double getValue(Attribute a) {
        return this.data.get(a);
    }

    public void setValue(Attribute a, double value) {
        this.data.set(a, value);
    }

    public void setValue(Attribute a, String str) {
        if (!a.isNominal()) {
            throw new IllegalArgumentException("setValue(Attribute, String) only supported for nominal values!");
        }
        if (str != null) {
            this.setValue(a, a.getMapping().mapString(str));
        } else {
            this.setValue(a, Double.NaN);
        }
    }

    public String getValueAsString(Attribute attribute) {
        return this.getValueAsString(attribute, -1);
    }

    public String getValueAsString(Attribute attribute, int fractionDigits) {
        double value = this.getValue(attribute);
        return attribute.getAsString(value, fractionDigits);
    }

    public double getLabel() {
        return this.getValue(this.getAttributes().getLabel());
    }

    public void setLabel(double value) {
        this.setValue(this.getAttributes().getLabel(), value);
    }

    public double getPredictedLabel() {
        return this.getValue(this.getAttributes().getPredictedLabel());
    }

    public void setPredictedLabel(double value) {
        this.setValue(this.getAttributes().getPredictedLabel(), value);
    }

    public double getId() {
        return this.getValue(this.getAttributes().getId());
    }

    public void setId(double value) {
        this.setValue(this.getAttributes().getId(), value);
    }

    public double getWeight() {
        return this.getValue(this.getAttributes().getWeight());
    }

    public void setWeight(double value) {
        this.setValue(this.getAttributes().getWeight(), value);
    }

    public double getConfidence(String classValue) {
        return this.getValue(this.getAttributes().getSpecial("confidence(" + classValue + ")"));
    }

    public void setConfidence(String classValue, double confidence) {
        this.setValue(this.getAttributes().getSpecial("confidence(" + classValue + ")"), confidence);
    }

    public String toString() {
        return this.toDenseString(-1);
    }

    public String getAttributesAsString() {
        return this.getAttributesAsString(SEPARATOR, -1);
    }

    public String getAttributesAsString(int fractionDigits) {
        return this.getAttributesAsString(SEPARATOR, fractionDigits);
    }

    public String getAttributesAsString(String sep, int fractionDigits) {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        for (Attribute attribute : this.getAttributes()) {
            if (!first) {
                str.append(sep);
            }
            str.append(this.getValueAsString(attribute, fractionDigits));
            first = false;
        }
        return str.toString();
    }

    public String toDenseString(int fractionDigits) {
        StringBuffer result = new StringBuffer();
        Iterator<Attribute> a = this.getAttributes().allAttributes();
        while (a.hasNext()) {
            result.append(String.valueOf(this.getValueAsString(a.next(), fractionDigits)) + SEPARATOR);
        }
        return result.toString();
    }

    public String toSparseString(int format, int fractionDigits) {
        Attribute weightAttribute;
        Attribute idAttribute;
        StringBuffer str = new StringBuffer();
        Attribute labelAttribute = this.getAttributes().getSpecial("label");
        if (format == 1 && labelAttribute != null) {
            str.append(String.valueOf(this.getValueAsString(labelAttribute, fractionDigits)) + SEPARATOR);
        }
        if ((idAttribute = this.getAttributes().getSpecial("id")) != null) {
            str.append("id:" + this.getValueAsString(idAttribute, fractionDigits) + SEPARATOR);
        }
        if ((weightAttribute = this.getAttributes().getSpecial("weight")) != null) {
            str.append("w:" + this.getValueAsString(weightAttribute, fractionDigits) + SEPARATOR);
        }
        str.append(String.valueOf(this.getAttributesAsSparseString(SEPARATOR, SPARSE_SEPARATOR, fractionDigits)) + SEPARATOR);
        if (format == 2 && labelAttribute != null) {
            str.append("l:" + this.getValueAsString(labelAttribute, fractionDigits));
        }
        if (format == 0 && labelAttribute != null) {
            str.append(this.getValueAsString(labelAttribute, fractionDigits));
        }
        return str.toString();
    }

    public String getAttributesAsSparseString(String separator, String indexValueSeparator, int fractionDigits) {
        StringBuffer str = new StringBuffer();
        boolean first = true;
        int counter = 1;
        for (Attribute attribute : this.getAttributes()) {
            double value = this.getValue(attribute);
            if (!Tools.isDefault(attribute.getDefault(), value)) {
                if (!first) {
                    str.append(separator);
                }
                first = false;
                str.append(String.valueOf(counter) + indexValueSeparator + this.getValueAsString(attribute, fractionDigits));
            }
            ++counter;
        }
        return str.toString();
    }
}

