/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleTable;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.DatabaseDataRow;
import edu.udo.cs.yale.example.DatabaseDataRowReader;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseExampleTable
extends AbstractExampleTable {
    private ResultSet resultSet;
    private DatabaseHandler databaseHandler;
    private String tableName;
    private int size = 0;

    private DatabaseExampleTable(ResultSet resultSet, List<Attribute> attributes, DatabaseHandler databaseHandler, String tableName) throws SQLException {
        super(attributes);
        this.resultSet = resultSet;
        this.databaseHandler = databaseHandler;
        this.tableName = tableName;
    }

    public static DatabaseExampleTable createDatabaseExampleTable(DatabaseHandler databaseHandler, String tableName) throws SQLException {
        ResultSet rs = databaseHandler.query("SELECT * FROM " + tableName);
        List<Attribute> attributes = DatabaseHandler.createAttributes(rs);
        DatabaseExampleTable table = new DatabaseExampleTable(rs, attributes, databaseHandler, tableName);
        return table;
    }

    private void resetResultSet() throws SQLException {
        this.resultSet = this.databaseHandler.query("SELECT * FROM " + this.tableName);
    }

    @Override
    public DataRowReader getDataRowReader() {
        try {
            this.resultSet.beforeFirst();
            return new DatabaseDataRowReader(this.resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while creating database DataRowReader: " + e, e);
        }
    }

    @Override
    public DataRow getDataRow(int index) {
        try {
            this.resultSet.absolute(index + 1);
            DatabaseDataRow dataRow = new DatabaseDataRow(this.resultSet);
            return dataRow;
        }
        catch (SQLException e) {
            LogService.logMessage("Cannot retrieve data row with absolute row index: " + e.getMessage(), 4);
            return null;
        }
    }

    @Override
    public int addAttribute(Attribute attribute) {
        int index = super.addAttribute(attribute);
        if (this.databaseHandler == null) {
            return index;
        }
        try {
            this.close();
            this.databaseHandler.addColumn(attribute, this.tableName);
            this.resetResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while adding a column to database: " + e, e);
        }
        return index;
    }

    @Override
    public void removeAttribute(Attribute attribute) {
        super.removeAttribute(attribute);
        try {
            this.close();
            this.databaseHandler.removeColumn(attribute, this.tableName);
            this.resetResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while removing a column from database: " + e, e);
        }
    }

    @Override
    public int size() {
        try {
            this.size = this.databaseHandler.countRecords(this.resultSet);
        }
        catch (SQLException e) {
            LogService.logMessage("DatabaseExampleTable: cannot count number of records: " + e.getMessage(), 4);
        }
        return this.size;
    }

    private void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
                this.resultSet = null;
            }
            catch (SQLException e) {
                LogService.logMessage("DatabaseExampleTable: cannot close result set: " + e.getMessage(), 4);
            }
        }
    }

    protected void finalize() {
        this.close();
    }
}

