/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.Attribute;

public class ConstructionDescription {
    private String generatingFunctionName;
    private ConstructionDescription[] generatingFunctionArguments = null;
    private Attribute attribute;

    public ConstructionDescription(Attribute attribute, String name) {
        this.generatingFunctionName = name;
        this.attribute = attribute;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConstructionDescription)) {
            return false;
        }
        ConstructionDescription other = (ConstructionDescription)o;
        if (!this.generatingFunctionName.equals(other.generatingFunctionName)) {
            return false;
        }
        if (this.generatingFunctionArguments == null && other.generatingFunctionArguments != null) {
            return false;
        }
        if (this.generatingFunctionArguments != null && other.generatingFunctionArguments == null) {
            return false;
        }
        if (this.generatingFunctionArguments != null && other.generatingFunctionArguments != null) {
            if (this.generatingFunctionArguments.length != other.generatingFunctionArguments.length) {
                return false;
            }
            int i = 0;
            while (i < this.generatingFunctionArguments.length) {
                if (!this.generatingFunctionArguments[i].equals(other.generatingFunctionArguments[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.generatingFunctionName != null) {
            hashCode ^= this.generatingFunctionName.hashCode();
        }
        if (this.generatingFunctionArguments != null) {
            hashCode ^= this.generatingFunctionArguments.hashCode();
        }
        return hashCode;
    }

    public void setFunction(String functionName) {
        this.generatingFunctionName = functionName;
    }

    public String getFunction() {
        return this.generatingFunctionName;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setArguments(ConstructionDescription[] arguments) {
        this.generatingFunctionArguments = arguments;
    }

    public ConstructionDescription[] getArguments() {
        return this.generatingFunctionArguments;
    }

    public String getDescription() {
        return this.getDescription(true);
    }

    public String getDescription(boolean useInfix) {
        boolean infixPossible;
        boolean bl = infixPossible = this.generatingFunctionArguments != null && this.generatingFunctionArguments.length == 2;
        if (this.generatingFunctionArguments == null) {
            return this.generatingFunctionName;
        }
        if (infixPossible && useInfix) {
            return "(" + this.generatingFunctionArguments[0].getDescription(useInfix) + this.generatingFunctionName + this.generatingFunctionArguments[1].getDescription(useInfix) + ")";
        }
        String cd = String.valueOf(this.generatingFunctionName) + "(";
        int i = 0;
        while (i < this.generatingFunctionArguments.length) {
            cd = String.valueOf(cd) + (i == 0 ? "" : ", ") + this.generatingFunctionArguments[i].getDescription(useInfix);
            ++i;
        }
        return String.valueOf(cd) + ")";
    }

    public int getDepth() {
        if (!this.isGenerated()) {
            return 0;
        }
        int max = -1;
        int i = 0;
        while (i < this.generatingFunctionArguments.length) {
            max = Math.max(max, this.generatingFunctionArguments[i].getDepth());
            ++i;
        }
        return max + 1;
    }

    public boolean isGenerated() {
        return this.generatingFunctionArguments != null;
    }

    public void clear() {
        this.generatingFunctionName = this.attribute.getName();
        this.generatingFunctionArguments = null;
    }

    public String toString() {
        return this.getDescription(true);
    }
}

