/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleSet;
import edu.udo.cs.yale.example.Attributes;
import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionExampleReader;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionedExampleSet
extends AbstractExampleSet {
    private ExampleSet parent;
    private Condition condition;
    private int size = -1;
    private int[] mapping;
    private boolean inverted = false;

    public ConditionedExampleSet(ExampleSet parent, Condition condition) {
        this(parent, condition, false);
    }

    public ConditionedExampleSet(ExampleSet parent, Condition condition, boolean inverted) {
        this.parent = parent;
        if (condition == null) {
            throw new IllegalArgumentException("Condition must not be null!");
        }
        this.condition = condition;
        this.inverted = inverted;
        this.updateCondition();
    }

    public ConditionedExampleSet(ConditionedExampleSet exampleSet) {
        this.parent = (ExampleSet)exampleSet.parent.clone();
        this.condition = exampleSet.condition.duplicate();
        this.size = exampleSet.size;
        this.mapping = new int[exampleSet.mapping.length];
        this.inverted = exampleSet.inverted;
        System.arraycopy(exampleSet.mapping, 0, this.mapping, 0, exampleSet.mapping.length);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof ConditionedExampleSet)) {
            return false;
        }
        return this.condition.equals(((ConditionedExampleSet)o).condition);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.condition.hashCode();
    }

    public void updateCondition() {
        Iterator<Example> reader = this.iterator();
        this.size = 0;
        while (reader.hasNext()) {
            ++this.size;
            reader.next();
        }
        this.mapping = new int[this.size];
        int exampleCounter = 0;
        int conditionCounter = 0;
        for (Example example : this.parent) {
            if (!this.inverted) {
                if (this.condition.conditionOk(example)) {
                    this.mapping[conditionCounter++] = exampleCounter;
                }
            } else if (!this.condition.conditionOk(example)) {
                this.mapping[conditionCounter++] = exampleCounter;
            }
            ++exampleCounter;
        }
    }

    @Override
    public Iterator<Example> iterator() {
        return new ConditionExampleReader(this.parent.iterator(), this.condition, this.inverted);
    }

    @Override
    public Example getExample(int index) {
        if (index < 0 || index >= this.mapping.length) {
            throw new RuntimeException("Given index '" + index + "' does not fit the filtered ExampleSet!");
        }
        return this.parent.getExample(this.mapping[index]);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Attributes getAttributes() {
        return this.parent.getAttributes();
    }

    @Override
    public Example getExampleFromId(double id) {
        return new Example(this.parent.getExampleFromId(id).getDataRow(), this);
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.parent.getExampleTable();
    }

    @Override
    public void remapIds() {
        this.parent.remapIds();
    }
}

