/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractExampleReader;
import edu.udo.cs.yale.example.AcceptAllCondition;
import edu.udo.cs.yale.example.AttributeValueFilter;
import edu.udo.cs.yale.example.Condition;
import edu.udo.cs.yale.example.ConditionCreationException;
import edu.udo.cs.yale.example.CorrectPredictionCondition;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MissingAttributesCondition;
import edu.udo.cs.yale.example.MissingLabelsCondition;
import edu.udo.cs.yale.example.NoMissingAttributesCondition;
import edu.udo.cs.yale.example.NoMissingLabelsCondition;
import edu.udo.cs.yale.example.WrongPredictionCondition;
import edu.udo.cs.yale.tools.Tools;
import java.lang.reflect.Constructor;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionExampleReader
extends AbstractExampleReader {
    public static final String[] KNOWN_CONDITION_NAMES = new String[]{"all", "correct_predictions", "wrong_predictions", "no_missing_attributes", "missing_attributes", "no_missing_labels", "missing_labels", "attribute_value_filter"};
    private static final String[] KNOWN_CONDITION_IMPLEMENTATIONS = new String[]{AcceptAllCondition.class.getName(), CorrectPredictionCondition.class.getName(), WrongPredictionCondition.class.getName(), NoMissingAttributesCondition.class.getName(), MissingAttributesCondition.class.getName(), NoMissingLabelsCondition.class.getName(), MissingLabelsCondition.class.getName(), AttributeValueFilter.class.getName()};
    private Iterator<Example> parent;
    private Condition condition;
    private Example currentExample;
    private boolean inverted = false;

    public ConditionExampleReader(Iterator<Example> parent, Condition condition, boolean inverted) {
        this.parent = parent;
        this.currentExample = null;
        this.condition = condition;
        this.inverted = inverted;
    }

    @Override
    public boolean hasNext() {
        while (this.currentExample == null) {
            if (!this.parent.hasNext()) {
                return false;
            }
            Example e = this.parent.next();
            if (!this.inverted) {
                if (!this.condition.conditionOk(e)) continue;
                this.currentExample = e;
                continue;
            }
            if (this.condition.conditionOk(e)) continue;
            this.currentExample = e;
        }
        return true;
    }

    @Override
    public Example next() {
        this.hasNext();
        Example dummy = this.currentExample;
        this.currentExample = null;
        return dummy;
    }

    public static Condition createCondition(String name, ExampleSet exampleSet, String parameterString) throws ConditionCreationException {
        String className = name;
        int i = 0;
        while (i < KNOWN_CONDITION_NAMES.length) {
            if (KNOWN_CONDITION_NAMES[i].equals(name)) {
                className = KNOWN_CONDITION_IMPLEMENTATIONS[i];
                break;
            }
            ++i;
        }
        try {
            Class clazz = Tools.classForName(className);
            if (!Condition.class.isAssignableFrom(clazz)) {
                throw new ConditionCreationException("'" + className + "' does not implement Condition!");
            }
            Constructor constructor = clazz.getConstructor(ExampleSet.class, String.class);
            return (Condition)constructor.newInstance(exampleSet, parameterString);
        }
        catch (ClassNotFoundException e) {
            throw new ConditionCreationException("Cannot find class '" + className + "'. Check your classpath.");
        }
        catch (NoSuchMethodException e) {
            throw new ConditionCreationException("'" + className + "' must implement two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (IllegalAccessException e) {
            throw new ConditionCreationException("'" + className + "' cannot access two argument constructor " + className + "(ExampleSet, String)!");
        }
        catch (InstantiationException e) {
            throw new ConditionCreationException(String.valueOf(className) + ": cannot create condition (" + e.getMessage() + ").");
        }
        catch (Throwable e) {
            throw new ConditionCreationException(String.valueOf(className) + ": cannot invoke condition (" + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage()) + ").");
        }
    }
}

