/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.AbstractSparseArrayDataRow;

public class BooleanSparseArrayDataRow
extends AbstractSparseArrayDataRow {
    private boolean[] values;

    public BooleanSparseArrayDataRow() {
        this(0);
    }

    public BooleanSparseArrayDataRow(int size) {
        super(size);
        this.values = new boolean[size];
    }

    protected void swapValues(int a, int b) {
        boolean tt = this.values[a];
        this.values[a] = this.values[b];
        this.values[b] = tt;
    }

    public void resizeValues(int length) {
        boolean[] d = new boolean[length];
        System.arraycopy(this.values, 0, d, 0, Math.min(this.values.length, length));
        this.values = d;
    }

    public void removeValue(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.values.length - (index + 1));
    }

    public double getValue(int index) {
        return this.values[index] ? 1.0 : 0.0;
    }

    public void setValue(int index, double v) {
        this.values[index] = v != 0.0;
    }

    protected double[] getAllValues() {
        double[] result = new double[this.values.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.values[i] ? 1.0 : 0.0;
            ++i;
        }
        return result;
    }
}

