/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.example;

import edu.udo.cs.yale.example.DataRow;

public class BooleanArrayDataRow
extends DataRow {
    private boolean[] data;

    public BooleanArrayDataRow(boolean[] data) {
        this.data = data;
    }

    double get(int index, double defaultValue) {
        if (this.data[index]) {
            return 1.0;
        }
        return 0.0;
    }

    void set(int index, double value, double defaultValue) {
        this.data[index] = value != 0.0;
    }

    void ensureNumberOfColumns(int numberOfColumns) {
        if (this.data.length >= numberOfColumns) {
            return;
        }
        boolean[] newData = new boolean[numberOfColumns];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    public void trim() {
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.data.length) {
            result.append(String.valueOf(i == 0 ? "" : ",") + this.data[i]);
            ++i;
        }
        return result.toString();
    }
}

